/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDocItens;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.TipoArquivamentoDoc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ARQUIVAMENTO_DOC")
public class ArquivamentoDoc
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String observacao;
    private List<ArquivamentoDocItens> itensDoc = new ArrayList<ArquivamentoDocItens>();
    private Date dataCadastro;
    private Date dataAtualizacao;
    private Empresa empresa;
    private Nodo nodo;
    private Long idRegistro;
    private String voClass;
    private TipoArquivamentoDoc tipoArquivamentoDoc;

    @Id
    @Column(nullable=false, unique=true, name="ID_ARQUIVAMENTO_DOC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ARQUIVAMENTO_DOC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="arquivamentoDoc")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ArquivamentoDocItens> getItensDoc() {
        return this.itensDoc;
    }

    public void setItensDoc(List<ArquivamentoDocItens> itensDoc) {
        this.itensDoc = itensDoc;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ARQUIVAMENTO_DOC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NODO", foreignKey=@ForeignKey(name="FK_ARQUIVAMENTO_DOC_NODO"))
    public Nodo getNodo() {
        return this.nodo;
    }

    public void setNodo(Nodo nodo) {
        this.nodo = nodo;
    }

    @Ignore
    @Column(name="ID_REGISTRO")
    public Long getIdRegistro() {
        return this.idRegistro;
    }

    public void setIdRegistro(Long idRegistro) {
        this.idRegistro = idRegistro;
    }

    @Column(name="VO_CLASS", length=1500)
    public String getVoClass() {
        return this.voClass;
    }

    public void setVoClass(String voClass) {
        this.voClass = voClass;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ARQUIVAMENTO_DOC")
    public TipoArquivamentoDoc getTipoArquivamentoDoc() {
        return this.tipoArquivamentoDoc;
    }

    public void setTipoArquivamentoDoc(TipoArquivamentoDoc tipoArquivamentoDoc) {
        this.tipoArquivamentoDoc = tipoArquivamentoDoc;
    }
}

