/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="ATIVO_TIPO_PONTO_CONTROLE")
public class AtivoTipoPontoControle
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Equipamento ativo;
    private TipoPontoControle tipoPontoControle;
    private Coleta coletaLimite;
    private PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo;

    @Id
    @Column(nullable=false, name="ID_ATIVO_TIPO_PONTO_CONTROLE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ATIVO_TIPO_PONTO_CONTROLE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ATIVO_TIPO_PONTO_CONT_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_ATIVO_TIPO_PONTO_CONT_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_ATIVO_TIPO_PONTO_CONT_AT_P_C"))
    public TipoPontoControle getTipoPontoControle() {
        return this.tipoPontoControle;
    }

    public void setTipoPontoControle(TipoPontoControle tipoPontoControle) {
        this.tipoPontoControle = tipoPontoControle;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLETA_LIMITE", foreignKey=@ForeignKey(name="FK_ATIVO_TIPO_PONTO_CONT_COL_LI"))
    public Coleta getColetaLimite() {
        return this.coletaLimite;
    }

    public void setColetaLimite(Coleta coletaLimite) {
        this.coletaLimite = coletaLimite;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_MANUTENCAO_ATIVO_ATIVO", foreignKey=@ForeignKey(name="FK_ATIVO_TIPO_PONTO_CONT_PLAN_M"))
    public PlanoManutencaoAtivoAtivo getPlanoManutencaoAtivoAtivo() {
        return this.planoManutencaoAtivoAtivo;
    }

    public void setPlanoManutencaoAtivoAtivo(PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo) {
        this.planoManutencaoAtivoAtivo = planoManutencaoAtivoAtivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        Object toString = "";
        if (this.ativo != null) {
            toString = (String)toString + this.ativo.getNome();
            if (this.tipoPontoControle != null) {
                toString = (String)toString + "-" + this.tipoPontoControle.getDescricao();
            }
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{toString});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

