/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAtualizacaoSalarial;
import com.touchcomp.basementor.model.vo.TipoAlteracaoSalarial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ATUALIZACAO_SALARIAL")
public class AtualizacaoSalarial
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Date periodo;
    private List<ItemAtualizacaoSalarial> itensAtualizacaoSalarial = new ArrayList<ItemAtualizacaoSalarial>();
    private Timestamp dataAtualizacao;
    private String descricao;
    private List<ColaboradorSalario> colaboradoresSalario = new ArrayList<ColaboradorSalario>();
    private TipoAlteracaoSalarial tipoAlteracaoSalarial;
    private String observacao;
    private Short informarValorPercentual = 0;
    private Date periodoDataBase;
    private Short filtroAtualizacao = 3;

    @Id
    @Column(name="ID_ATUALIZACAO_SALARIAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ATUALIZACAO_SALARIAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ATUALIZACAO_SALARIAL_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao(), this.getPeriodo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PERIODO_ATUALIZACAO_SALARIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @OneToMany(targetEntity=ItemAtualizacaoSalarial.class, cascade={CascadeType.ALL}, mappedBy="atualizacaoSalarial", fetch=FetchType.LAZY)
    public List<ItemAtualizacaoSalarial> getItensAtualizacaoSalarial() {
        return this.itensAtualizacaoSalarial;
    }

    public void setItensAtualizacaoSalarial(List<ItemAtualizacaoSalarial> atualizacoesSalariais) {
        this.itensAtualizacaoSalarial = atualizacoesSalariais;
    }

    @OneToMany(targetEntity=ColaboradorSalario.class, cascade={CascadeType.ALL}, mappedBy="atualizacaoSalarial", fetch=FetchType.LAZY)
    public List<ColaboradorSalario> getColaboradoresSalario() {
        return this.colaboradoresSalario;
    }

    public void setColaboradoresSalario(List<ColaboradorSalario> colaboradoresSalario) {
        this.colaboradoresSalario = colaboradoresSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ALTERACAO_SALARIAL", foreignKey=@ForeignKey(name="FK_ATUALIZACAO_SALARIAL_2"))
    public TipoAlteracaoSalarial getTipoAlteracaoSalarial() {
        return this.tipoAlteracaoSalarial;
    }

    public void setTipoAlteracaoSalarial(TipoAlteracaoSalarial tipoAlteracaoSalarial) {
        this.tipoAlteracaoSalarial = tipoAlteracaoSalarial;
    }

    @Column(name="OBSERVACAO", length=100)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="INFORMAR_VALOR_PERCENTUAL")
    public Short getInformarValorPercentual() {
        return this.informarValorPercentual;
    }

    public void setInformarValorPercentual(Short informarValorPercentual) {
        this.informarValorPercentual = informarValorPercentual;
    }

    @Column(name="PERIODO_DATA_BASE")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoDataBase() {
        return this.periodoDataBase;
    }

    public void setPeriodoDataBase(Date periodoDataBase) {
        this.periodoDataBase = periodoDataBase;
    }

    @Column(name="FILTRO_ATUALIZACAO")
    public Short getFiltroAtualizacao() {
        return this.filtroAtualizacao;
    }

    public void setFiltroAtualizacao(Short filtroAtualizacao) {
        this.filtroAtualizacao = filtroAtualizacao;
    }
}

