/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BombaCombustivel;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.TanqueCombustivel;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="BICO_BOMBA_COMBUSTIVEL", uniqueConstraints={@UniqueConstraint(name="UNQ1_BICO_BOMBA_COMB_BOMBA", columnNames={"ID_BOMBA_COMBUSTIVEL", "CODIGO"})})
public class BicoBombaCombustivel
implements InterfaceVO {
    private Long identificador;
    private Timestamp dataAtualizacao;
    private String descricao;
    private GradeCor gradeCor;
    private String codigo;
    private String codigoAutomacao;
    private BombaCombustivel bombaCombustivel;
    private TanqueCombustivel tanqueCombustivel;
    private Integer numeroSequencial = 0;
    private Short ativo = 1;
    private Date dataDesativacao;

    @Id
    @Column(nullable=false, name="ID_BICO_BOMBA_COMBUSTIVEL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BICO_BOMBA_COMBUSTIVEL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=10)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_BICO_BOMBA_COMBUS_GRADE"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Column(name="CODIGO", length=10)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Column(name="CODIGO_AUTOMACAO", length=50)
    public String getCodigoAutomacao() {
        return this.codigoAutomacao;
    }

    public void setCodigoAutomacao(String codigoAutomacao) {
        this.codigoAutomacao = codigoAutomacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BOMBA_COMBUSTIVEL", foreignKey=@ForeignKey(name="FK_BICO_BOMBA_COMBUS_BOMBA"))
    public BombaCombustivel getBombaCombustivel() {
        return this.bombaCombustivel;
    }

    public void setBombaCombustivel(BombaCombustivel bombaCombustivel) {
        this.bombaCombustivel = bombaCombustivel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TANQUE_COMBUSTIVEL", foreignKey=@ForeignKey(name="FK_BICO_BOMBA_COMBUS_TANQUE"))
    public TanqueCombustivel getTanqueCombustivel() {
        return this.tanqueCombustivel;
    }

    public void setTanqueCombustivel(TanqueCombustivel tanqueCombustivel) {
        this.tanqueCombustivel = tanqueCombustivel;
    }

    @Column(name="NUMERO_SEQUENCIAL")
    public Integer getNumeroSequencial() {
        return this.numeroSequencial;
    }

    public void setNumeroSequencial(Integer numeroSequencial) {
        this.numeroSequencial = numeroSequencial;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}-{1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getCodigo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_desativacao")
    public Date getDataDesativacao() {
        return this.dataDesativacao;
    }

    public void setDataDesativacao(Date dataDesativacao) {
        this.dataDesativacao = dataDesativacao;
    }
}

