/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="BOLETO_TITULO")
public class BoletoTitulo
implements InterfaceVO {
    private Long identificador;
    private CarteiraCobranca carteiraCobranca;
    private Titulo titulo;
    private Timestamp dataAtualizacao;
    private String codigoBarras;
    private String numeroTituloInst;
    private Short ativo = 1;
    private Double valorBase = 0.0;
    private Double valorJuros = 0.0;
    private Double percJuros = 0.0;
    private Double valorMulta = 0.0;
    private Double percMulta = 0.0;
    private Double valorDesconto = 0.0;
    private Double percDesconto = 0.0;
    private Date dataLimiteDesconto;
    private Double valorDespBanc = 0.0;
    private Double valorTotal = 0.0;
    private Double valorBoleto = 0.0;
    private Date dataVencimento;
    private Date dataCadastro;
    private Short calcularJuros = 0;
    private Short calcularMulta = 0;
    private Short calcularDespBanc = 0;
    private List<LogTitulos> logTitulos = new ArrayList<LogTitulos>();
    private Short informarValorManual = 0;
    private String observacao;
    private List<ItemAltBoletoHist> itensAltBoleto = new ArrayList<ItemAltBoletoHist>();
    private Long nrTitulo = 0L;
    private Double valorAbatimento = 0.0;

    @Id
    @Column(name="ID_BOLETO_TITULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BOLETO_TITULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_BOLETO_TITULO_CART"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_BOLETO_TITULO_TIT"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CODIGO_BARRAS", length=100)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Column(insertable=false, updatable=false, name="NUM_TITULO_INST_FINANCEIRA", length=50)
    @Generated(value=GenerationTime.ALWAYS)
    public String getNumeroTituloInst() {
        return this.numeroTituloInst;
    }

    public void setNumeroTituloInst(String numeroSeqTituloInst) {
        this.numeroTituloInst = numeroSeqTituloInst;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="VALOR_BASE", precision=15, scale=2)
    public Double getValorBase() {
        return this.valorBase;
    }

    public void setValorBase(Double valorBoleto) {
        this.valorBase = valorBoleto;
    }

    @Column(name="VALOR_JUROS", precision=15, scale=2)
    public Double getValorJuros() {
        return this.valorJuros;
    }

    public void setValorJuros(Double valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Column(name="VALOR_MULTA", precision=15, scale=2)
    public Double getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(Double valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="VALOR_BOLETO", precision=15, scale=2)
    public Double getValorBoleto() {
        return this.valorBoleto;
    }

    public void setValorBoleto(Double valorBoleto) {
        this.valorBoleto = valorBoleto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="CALCULAR_JUROS")
    public Short getCalcularJuros() {
        return this.calcularJuros;
    }

    public void setCalcularJuros(Short calculadoJuros) {
        this.calcularJuros = calculadoJuros;
    }

    @Column(name="CALCULAR_MULTA")
    public Short getCalcularMulta() {
        return this.calcularMulta;
    }

    public void setCalcularMulta(Short calcularMulta) {
        this.calcularMulta = calcularMulta;
    }

    @Column(name="CALCULAR_DESP_BANC")
    public Short getCalcularDespBanc() {
        return this.calcularDespBanc;
    }

    public void setCalcularDespBanc(Short calcularDespBanc) {
        this.calcularDespBanc = calcularDespBanc;
    }

    @Column(name="PERC_JUROS", precision=15, scale=2)
    public Double getPercJuros() {
        return this.percJuros;
    }

    public void setPercJuros(Double percJuros) {
        this.percJuros = percJuros;
    }

    @Column(name="PERC_MULTA", precision=15, scale=2)
    public Double getPercMulta() {
        return this.percMulta;
    }

    public void setPercMulta(Double percMulta) {
        this.percMulta = percMulta;
    }

    @Column(name="VALOR_DESP_BANC", precision=15, scale=2)
    public Double getValorDespBanc() {
        return this.valorDespBanc;
    }

    public void setValorDespBanc(Double valorDespBanc) {
        this.valorDespBanc = valorDespBanc;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIMITE_DESCONTO")
    public Date getDataLimiteDesconto() {
        return this.dataLimiteDesconto;
    }

    public void setDataLimiteDesconto(Date dataLimiteDesconto) {
        this.dataLimiteDesconto = dataLimiteDesconto;
    }

    @Column(name="PERC_DESCONTO", precision=15, scale=2)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @OneToMany(mappedBy="boletoTitulo", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<LogTitulos> getLogTitulos() {
        return this.logTitulos;
    }

    public void setLogTitulos(List<LogTitulos> logTitulos) {
        this.logTitulos = logTitulos;
    }

    @Column(name="INFORMAR_VALOR_MANUAL")
    public Short getInformarValorManual() {
        return this.informarValorManual;
    }

    public void setInformarValorManual(Short informarValorManual) {
        this.informarValorManual = informarValorManual;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="boletoTitulo")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemAltBoletoHist> getItensAltBoleto() {
        return this.itensAltBoleto;
    }

    public void setItensAltBoleto(List<ItemAltBoletoHist> itensAltBoleto) {
        this.itensAltBoleto = itensAltBoleto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        Object to = "Boleto nr ";
        if (this.numeroTituloInst != null) {
            to = (String)to + this.numeroTituloInst + " ";
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{to});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NR_TITULO")
    public Long getNrTitulo() {
        return this.nrTitulo;
    }

    public void setNrTitulo(Long nrTitulo) {
        this.nrTitulo = nrTitulo;
    }

    @Column(name="valor_abatimento")
    public Double getValorAbatimento() {
        return this.valorAbatimento;
    }

    public void setValorAbatimento(Double valorAbatimento) {
        this.valorAbatimento = valorAbatimento;
    }
}

