/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_EVENTO_CONSIGNADO")
public class CadastroEventoConsignado
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Colaborador colaborador;
    private Double valor = 0.0;
    private Integer nrParcelas = 0;
    private TipoCalculoEvento eventoConsignado;
    private Date dataInicioDesconto;
    private Date dataFinalDesconto;
    private List<EventoColaborador> eventoColaborador = new ArrayList<EventoColaborador>();
    private String observacao;
    private Short renegociado = 0;
    private String codigoBanco;
    private String numeroContratoEmprestimo;
    private String instituicaoConsignataria;
    private String contratoInstituicaoConsignataria;
    private Date dataInicioContrato;

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_EVENTO_CONSIGNADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_EVENTO_CONSIGNADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CADASTRO_EVENTO_CONSIG_PESSO"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CADASTRO_EVENTO_CONSIG_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=4)
    public Double getValor() {
        this.valor = this.valor == null || this.valor <= 0.0 ? 0.0 : this.valor;
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor = Double.valueOf(valor == null || valor <= 0.0 ? 0.0 : valor);
    }

    @Column(name="NR_PARCELAS", precision=15, scale=2)
    public Integer getNrParcelas() {
        return this.nrParcelas;
    }

    public void setNrParcelas(Integer nrParcelas) {
        this.nrParcelas = nrParcelas;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_EVENTO_CONSIGNADO", foreignKey=@ForeignKey(name="FK_CADASTRO_EVENTO_CONSIG_EVENT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoCalculoEvento getEventoConsignado() {
        return this.eventoConsignado;
    }

    public void setEventoConsignado(TipoCalculoEvento eventoConsignado) {
        this.eventoConsignado = eventoConsignado;
    }

    @Column(name="DATA_INICIO_DESCONTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioDesconto() {
        return this.dataInicioDesconto;
    }

    public void setDataInicioDesconto(Date dataInicioDesconto) {
        this.dataInicioDesconto = dataInicioDesconto;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CADASTRO_EVENTO_CONSIG_EMPRE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="eventoConsignado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EventoColaborador> getEventoColaborador() {
        return this.eventoColaborador;
    }

    public void setEventoColaborador(List<EventoColaborador> eventoColaborador) {
        this.eventoColaborador = eventoColaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_DESCONTO")
    public Date getDataFinalDesconto() {
        return this.dataFinalDesconto;
    }

    public void setDataFinalDesconto(Date dataFinalDesconto) {
        this.dataFinalDesconto = dataFinalDesconto;
    }

    @Column(name="OBSERVACAO", length=800)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="RENEGOCIADO")
    public Short getRenegociado() {
        return this.renegociado;
    }

    public void setRenegociado(Short renegociado) {
        this.renegociado = renegociado;
    }

    @Column(name="codigo_banco")
    public String getCodigoBanco() {
        return this.codigoBanco;
    }

    public void setCodigoBanco(String codigoBanco) {
        this.codigoBanco = codigoBanco;
    }

    @Column(name="numero_contrato_emprestimo")
    public String getNumeroContratoEmprestimo() {
        return this.numeroContratoEmprestimo;
    }

    public void setNumeroContratoEmprestimo(String numeroContratoEmprestimo) {
        this.numeroContratoEmprestimo = numeroContratoEmprestimo;
    }

    @Column(name="instituicao_consignataria")
    public String getInstituicaoConsignataria() {
        return this.instituicaoConsignataria;
    }

    public void setInstituicaoConsignataria(String instituicaoConsignataria) {
        this.instituicaoConsignataria = instituicaoConsignataria;
    }

    @Column(name="CONTRATO_INSTITUICAO_CONSIG")
    public String getContratoInstituicaoConsignataria() {
        return this.contratoInstituicaoConsignataria;
    }

    public void setContratoInstituicaoConsignataria(String contratoInstituicaoConsignataria) {
        this.contratoInstituicaoConsignataria = contratoInstituicaoConsignataria;
    }

    @Column(name="DATA_INICIO_CONTRATO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioContrato() {
        return this.dataInicioContrato;
    }

    public void setDataInicioContrato(Date dataInicioContrato) {
        this.dataInicioContrato = dataInicioContrato;
    }
}

