/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GerenciadoraTransporte;
import com.touchcomp.basementor.model.vo.OperadoraLinhaTransporte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="CADASTRO_LINHA_TRANSPORTE")
public class CadastroLinhaTransporte
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Double tarifa = 0.0;
    private GerenciadoraTransporte gerenciadora;
    private OperadoraLinhaTransporte operadoraLinha;
    private Short ativa = 1;
    private Short possuiValorFixo = 1;
    private String descDetalhada;

    @Id
    @Column(nullable=false, unique=true, name="ID_LINHA_TRANSPORTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LINHA_TRANSPORTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LINHA_TRANSPORTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="TARIFA", precision=15, scale=2)
    public Double getTarifa() {
        return this.tarifa;
    }

    public void setTarifa(Double tarifa) {
        this.tarifa = tarifa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GERENCIADORA", foreignKey=@ForeignKey(name="FK_LINHA_TRANSPORTE_GERENCIADOR"))
    public GerenciadoraTransporte getGerenciadora() {
        return this.gerenciadora;
    }

    public void setGerenciadora(GerenciadoraTransporte gerenciadora) {
        this.gerenciadora = gerenciadora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OPERADORA_LINHA", foreignKey=@ForeignKey(name="FK_LINHA_OPERADORA_LINHA_TRANSP"))
    public OperadoraLinhaTransporte getOperadoraLinha() {
        return this.operadoraLinha;
    }

    public void setOperadoraLinha(OperadoraLinhaTransporte operadoraLinha) {
        this.operadoraLinha = operadoraLinha;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtiva() {
        return this.ativa;
    }

    public void setAtiva(Short ativa) {
        this.ativa = ativa;
    }

    @Column(name="POSSUI_VALOR_FIXO")
    public Short getPossuiValorFixo() {
        return this.possuiValorFixo;
    }

    public void setPossuiValorFixo(Short possuiValorFixo) {
        this.possuiValorFixo = possuiValorFixo;
    }

    @Column(name="DESC_DETALHADA", length=500)
    public String getDescDetalhada() {
        return this.descDetalhada;
    }

    public void setDescDetalhada(String descDetalhada) {
        this.descDetalhada = descDetalhada;
    }
}

