/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="CANCELAMENTO_NFE", uniqueConstraints={@UniqueConstraint(name="UNQ1_CANCELAMENTO_NFE", columnNames={"ID_NOTA_FISCAL_PROPRIA"})})
public class CancelamentoNFe
implements InterfaceVO {
    private Long identificador;
    private NotaFiscalPropria notaFiscalPropria;
    private Date dataCadastro;
    private Empresa empresa;
    private String motivoCancelamento;
    private String nrProtocoloCancelamento;

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_CANCELAMENTO_NFE_NT_PROPRIA"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CANCELAMENTO_NFE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Id
    @Column(nullable=false, name="ID_CANCELAMENTO_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CANCELAMENTO_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=255)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Column(name="NR_PROTOCOLO_CANCELAMENTO", length=15)
    public String getNrProtocoloCancelamento() {
        return this.nrProtocoloCancelamento;
    }

    public void setNrProtocoloCancelamento(String nrProtocoloCancelamento) {
        this.nrProtocoloCancelamento = nrProtocoloCancelamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

