/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CARTAO_COOPERADO")
public class CartaoCooperado
implements InterfaceVO {
    private Long identificador;
    private Short ativo;
    private Date dataVencimento;
    private String numeroCartao;
    private String registroIncra;
    private Endereco endereco;
    private Cooperado cooperado;

    public CartaoCooperado() {
        this.ativo = EnumConstantsMentorSimNao.NAO.value;
    }

    @Id
    @Column(nullable=false, name="ID_CARTAO_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CARTAO_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(name="NUMERO_CARTAO", length=50)
    public String getNumeroCartao() {
        return this.numeroCartao;
    }

    public void setNumeroCartao(String numeroCartao) {
        this.numeroCartao = numeroCartao;
    }

    @Column(name="REGISTRO_INCRA", length=50)
    public String getRegistroIncra() {
        return this.registroIncra;
    }

    public void setRegistroIncra(String registroIncra) {
        this.registroIncra = registroIncra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @JoinColumn(name="ID_ENDERECO", foreignKey=@ForeignKey(name="FK_CARTAO_COOPERADO_ENDERECO"))
    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COOPERADO", foreignKey=@ForeignKey(name="FK_CARTAO_COOPERADO_COOPERADO"))
    public Cooperado getCooperado() {
        return this.cooperado;
    }

    public void setCooperado(Cooperado cooperado) {
        this.cooperado = cooperado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumeroCartao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

