/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCustoEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CENTRO_CUSTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_CENTRO_CUSTO", columnNames={"CODIGO"})})
public class CentroCusto
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String nome;
    private Short marca;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<CentroCustoEmpresa> centroCustoEmpresa;

    public CentroCusto() {
        this.marca = EnumConstSinteticoAnalitico.SINTETICO.getValue();
        this.centroCustoEmpresa = new ArrayList<CentroCustoEmpresa>();
    }

    public CentroCusto(Long id, String n, String c) {
        this.nome = n;
        this.identificador = id;
        this.codigo = c;
    }

    @Id
    @Column(name="ID_CENTRO_CUSTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CENTRO_CUSTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=false, name="CODIGO", length=10)
    public String getCodigo() {
        return this.codigo;
    }

    @Column(nullable=false, name="NOME", length=200)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CENTRO_CUSTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setIdentificador(Long idCentroCusto) {
        this.identificador = idCentroCusto;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="MARCA")
    public Short getMarca() {
        return this.marca;
    }

    public void setMarca(Short marca) {
        this.marca = marca;
    }

    @OneToMany(mappedBy="centroCusto")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CentroCustoEmpresa> getCentroCustoEmpresa() {
        return this.centroCustoEmpresa;
    }

    public void setCentroCustoEmpresa(List<CentroCustoEmpresa> centroCustoEmpresa) {
        this.centroCustoEmpresa = centroCustoEmpresa;
    }
}

