/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoCFOPRelCFOP;
import com.touchcomp.basementor.model.vo.LinhaMovimentoDAPI;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CFOP", uniqueConstraints={@UniqueConstraint(name="UNQ1_CFOP", columnNames={"CODIGO"})})
public class Cfop
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String descricao;
    private Short cfopDevolucaoVenda;
    private Short cfopDevolucaoCompra;
    private Short cfopReceitaVenda;
    private Short cfopCompra;
    private Short cfopIndustrializacao;
    private Short cfopComercialExportadora;
    private LinhaMovimentoDAPI tipoMovimentoDAPI;
    private Short cfopTransferencia;
    private Short cfopNotaProdutorRural;
    private Short cfopComercializacaoProdRural;
    private Short cfopEnergiaEletrica;
    private List<GrupoCFOPRelCFOP> grupoCFOPRel;
    private Timestamp dataAtualizacao;
    private Short cfopGeradorCredito;
    private Short cfopReceitaVendaSped;
    private String codigoDma;

    public Cfop(Long identificador, String codigo, String descricao, Short cfopDevolucaoVenda, Short cfopDevolucaoCompra, Short cfopReceitaVenda, Short cfopIndustrializacao, Short cfopComercialExportadora) {
        this.identificador = identificador;
        this.codigo = codigo;
        this.descricao = descricao;
        this.cfopDevolucaoVenda = cfopDevolucaoVenda;
        this.cfopDevolucaoCompra = cfopDevolucaoCompra;
        this.cfopReceitaVenda = cfopReceitaVenda;
        this.cfopIndustrializacao = cfopIndustrializacao;
        this.cfopCompra = 0;
        this.cfopNotaProdutorRural = 0;
        this.cfopComercialExportadora = cfopComercialExportadora;
        this.cfopTransferencia = 0;
        this.cfopEnergiaEletrica = 0;
        this.grupoCFOPRel = new ArrayList<GrupoCFOPRelCFOP>();
        this.cfopComercializacaoProdRural = 0;
        this.cfopComercializacaoProdRural = 1;
        this.cfopGeradorCredito = 0;
        this.cfopReceitaVendaSped = 0;
    }

    public Cfop() {
        this.cfopCompra = 0;
        this.cfopDevolucaoVenda = 0;
        this.cfopDevolucaoCompra = 0;
        this.cfopReceitaVenda = 0;
        this.cfopIndustrializacao = 0;
        this.cfopComercialExportadora = 0;
        this.cfopTransferencia = 0;
        this.cfopNotaProdutorRural = 0;
        this.cfopEnergiaEletrica = 0;
        this.cfopNotaProdutorRural = 0;
        this.grupoCFOPRel = new ArrayList<GrupoCFOPRelCFOP>();
        this.cfopComercializacaoProdRural = 0;
        this.cfopGeradorCredito = 0;
        this.cfopReceitaVendaSped = 0;
    }

    @Id
    @Column(name="ID_CFOP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CFOP")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="CODIGO", length=7)
    public String getCodigo() {
        return this.codigo;
    }

    @Column(nullable=false, name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setIdentificador(Long idCfop) {
        this.identificador = idCfop;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public Cfop(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    @Column(name="CFOP_DEVOLUCAO_VENDA")
    public Short getCfopDevolucaoVenda() {
        return this.cfopDevolucaoVenda;
    }

    public void setCfopDevolucaoVenda(Short cfopDevolucaoVenda) {
        this.cfopDevolucaoVenda = cfopDevolucaoVenda;
    }

    @Column(name="CFOP_DEVOLUCAO_COMPRA")
    public Short getCfopDevolucaoCompra() {
        return this.cfopDevolucaoCompra;
    }

    public void setCfopDevolucaoCompra(Short cfopDevolucaoCompra) {
        this.cfopDevolucaoCompra = cfopDevolucaoCompra;
    }

    @Column(name="CFOP_RECEITA_VENDA")
    public Short getCfopReceitaVenda() {
        return this.cfopReceitaVenda;
    }

    public void setCfopReceitaVenda(Short cfopReceitaVenda) {
        this.cfopReceitaVenda = cfopReceitaVenda;
    }

    @Column(name="CFOP_INDUSTRIALIZACAO")
    public Short getCfopIndustrializacao() {
        return this.cfopIndustrializacao;
    }

    public void setCfopIndustrializacao(Short cfopIndustrializacao) {
        this.cfopIndustrializacao = cfopIndustrializacao;
    }

    @Column(name="CFOP_COMERCIAL_EXPORTADORA")
    public Short getCfopComercialExportadora() {
        return this.cfopComercialExportadora;
    }

    public void setCfopComercialExportadora(Short cfopComercialExportadora) {
        this.cfopComercialExportadora = cfopComercialExportadora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LINHA_MOVIMENTO_DAPI", foreignKey=@ForeignKey(name="FK_CFOP_LINHA_MOV_DAPI"))
    public LinhaMovimentoDAPI getTipoMovimentoDAPI() {
        return this.tipoMovimentoDAPI;
    }

    public void setTipoMovimentoDAPI(LinhaMovimentoDAPI tipoMovimentoDAPI) {
        this.tipoMovimentoDAPI = tipoMovimentoDAPI;
    }

    @Column(name="CFOP_TRANSFERENCIA")
    public Short getCfopTransferencia() {
        return this.cfopTransferencia;
    }

    public void setCfopTransferencia(Short cfopTransferencia) {
        this.cfopTransferencia = cfopTransferencia;
    }

    @Column(name="CFOP_ENERGIA_ELETRICA")
    public Short getCfopEnergiaEletrica() {
        return this.cfopEnergiaEletrica;
    }

    public void setCfopEnergiaEletrica(Short cfopEnergiaEletrica) {
        this.cfopEnergiaEletrica = cfopEnergiaEletrica;
    }

    @OneToMany(mappedBy="cfop")
    public List<GrupoCFOPRelCFOP> getGrupoCFOPRel() {
        return this.grupoCFOPRel;
    }

    public void setGrupoCFOPRel(List<GrupoCFOPRelCFOP> grupoCFOPRel) {
        this.grupoCFOPRel = grupoCFOPRel;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CFOP_COMPRA")
    public Short getCfopCompra() {
        return this.cfopCompra;
    }

    public void setCfopCompra(Short cfopCompra) {
        this.cfopCompra = cfopCompra;
    }

    @Column(name="CFOP_NOTA_PROD_RURAL")
    public Short getCfopNotaProdutorRural() {
        return this.cfopNotaProdutorRural;
    }

    public void setCfopNotaProdutorRural(Short cfopNotaProdutorRural) {
        this.cfopNotaProdutorRural = cfopNotaProdutorRural;
    }

    @Column(name="CFOP_COMERCIO_PROD_RURAL")
    public Short getCfopComercializacaoProdRural() {
        return this.cfopComercializacaoProdRural;
    }

    public void setCfopComercializacaoProdRural(Short cfopComercializacaoProdRural) {
        this.cfopComercializacaoProdRural = cfopComercializacaoProdRural;
    }

    @Column(name="cfop_gerador_credito")
    public Short getCfopGeradorCredito() {
        return this.cfopGeradorCredito;
    }

    public void setCfopGeradorCredito(Short cfopGeradorCredito) {
        this.cfopGeradorCredito = cfopGeradorCredito;
    }

    @Column(name="CFOP_RECEITA_VENDA_SPED")
    public Short getCfopReceitaVendaSped() {
        return this.cfopReceitaVendaSped;
    }

    public void setCfopReceitaVendaSped(Short cfopReceitaVendaSped) {
        this.cfopReceitaVendaSped = cfopReceitaVendaSped;
    }

    @Column(name="codigo_dma", length=5)
    public String getCodigoDma() {
        return this.codigoDma;
    }

    public void setCodigoDma(String codigoDma) {
        this.codigoDma = codigoDma;
    }
}

