/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaChequeTerceiros;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CHEQUE_DE_TERCEIROS")
public class ChequeTerceiros
implements InterfaceVO {
    private Long identificador;
    private String banco;
    private String agencia;
    private String agenciaDC;
    private String contaCorrente;
    private String contaCorrenteDC;
    private Integer numero = 0;
    private String numeroDC;
    private Double valor = 0.0;
    private Double valorSaldo = 0.0;
    private String titular;
    private Date dataEntrada;
    private Date dataVencimento;
    private GrupoDeBaixaFormas grupoDeBaixaFormasRec;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private GrupoDeBaixaFormas grupoDeBaixaFormasPag;
    private CarteiraCobranca carteiraCobranca;
    private CompensacaoChequeTerceiros compensacaoCheque;
    private String observacao;
    private List<MovimentoBancario> movimentosBancarios = new ArrayList<MovimentoBancario>();
    private List<BaixaChequeTerceiros> baixaChequeTerceiros = new ArrayList<BaixaChequeTerceiros>();
    private Pessoa pessoa;
    private Representante representante;
    private ConfiguracaoCnab configuracaoCnab;
    private String codigoCMC;
    private String cnpjTitular;
    private Date dataBomPara;
    private String c1c2c3;
    private String serialForSinc;
    private ClassificacaoClientes classificacaoPessoa;

    @Id
    @Column(nullable=false, name="ID_CHEQUE_DE_TERCEIROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CHEQUE_TERCEIROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(unique=true, nullable=false, name="BANCO", length=5)
    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    @Column(unique=true, nullable=false, name="AGENCIA", length=5)
    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Column(unique=true, nullable=false, name="CONTA_CORRENTE", length=15)
    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    @Column(unique=true, nullable=false, name="NUMERO")
    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="VALOR_SALDO", precision=12, scale=2)
    public Double getValorSaldo() {
        return this.valorSaldo;
    }

    public void setValorSaldo(Double valorSaldo) {
        this.valorSaldo = valorSaldo;
    }

    @Column(nullable=false, name="TITULAR", length=500)
    public String getTitular() {
        return this.titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    @Column(nullable=false, name="DATA_ENTRADA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntrada() {
        return this.dataEntrada;
    }

    public void setDataEntrada(Date dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Column(nullable=false, name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CHEQUE_DE_TERCEIROS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getTitular()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="AGENCIA_DC", length=2)
    public String getAgenciaDC() {
        return this.agenciaDC;
    }

    public void setAgenciaDC(String agenciaDC) {
        this.agenciaDC = agenciaDC;
    }

    @Column(name="CONTA_CORRENTE_DC", length=2)
    public String getContaCorrenteDC() {
        return this.contaCorrenteDC;
    }

    public void setContaCorrenteDC(String contaCorrenteDC) {
        this.contaCorrenteDC = contaCorrenteDC;
    }

    @Column(name="NUMERO_DC", length=2)
    public String getNumeroDC() {
        return this.numeroDC;
    }

    public void setNumeroDC(String numeroDC) {
        this.numeroDC = numeroDC;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_CHEQUE_DE_TERCEIROS_CART_COB"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @OneToOne(mappedBy="cheque", fetch=FetchType.LAZY)
    public CompensacaoChequeTerceiros getCompensacaoCheque() {
        return this.compensacaoCheque;
    }

    public void setCompensacaoCheque(CompensacaoChequeTerceiros compensacaoCheque) {
        this.compensacaoCheque = compensacaoCheque;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="chequeTerceiros", fetch=FetchType.LAZY)
    public List<MovimentoBancario> getMovimentosBancarios() {
        return this.movimentosBancarios;
    }

    public void setMovimentosBancarios(List<MovimentoBancario> movimentosBancarios) {
        this.movimentosBancarios = movimentosBancarios;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="chequeTerceiros", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BaixaChequeTerceiros> getBaixaChequeTerceiros() {
        return this.baixaChequeTerceiros;
    }

    public void setBaixaChequeTerceiros(List<BaixaChequeTerceiros> baixaChequeTerceiros) {
        this.baixaChequeTerceiros = baixaChequeTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CHEQUE_DE_TERCEIROS_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_CHEQUE_DE_TERCEIROS_REPR"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA_FORMAS_REC", foreignKey=@ForeignKey(name="FK_CHEQUE_TERCEIROS_GR_BX_FR_RE"))
    public GrupoDeBaixaFormas getGrupoDeBaixaFormasRec() {
        return this.grupoDeBaixaFormasRec;
    }

    public void setGrupoDeBaixaFormasRec(GrupoDeBaixaFormas grupoDeBaixaFormasRec) {
        this.grupoDeBaixaFormasRec = grupoDeBaixaFormasRec;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA_FORMAS_PAG", foreignKey=@ForeignKey(name="FK_CHEQUE_TERCEIROS_GR_BX_FR_PA"))
    public GrupoDeBaixaFormas getGrupoDeBaixaFormasPag() {
        return this.grupoDeBaixaFormasPag;
    }

    public void setGrupoDeBaixaFormasPag(GrupoDeBaixaFormas grupoDeBaixaFormasPag) {
        this.grupoDeBaixaFormasPag = grupoDeBaixaFormasPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CNAB", foreignKey=@ForeignKey(name="FK_CHEQUE_TERCEIROS_CONF_CNAB"))
    public ConfiguracaoCnab getConfiguracaoCnab() {
        return this.configuracaoCnab;
    }

    public void setConfiguracaoCnab(ConfiguracaoCnab configuracaoCnab) {
        this.configuracaoCnab = configuracaoCnab;
    }

    @Column(name="CODIGO_CMC", length=50)
    public String getCodigoCMC() {
        return this.codigoCMC;
    }

    public void setCodigoCMC(String codigoCMC) {
        this.codigoCMC = codigoCMC;
    }

    @Column(name="CNPJ_TITULAR", length=14)
    public String getCnpjTitular() {
        return this.cnpjTitular;
    }

    public void setCnpjTitular(String cnpjTitular) {
        this.cnpjTitular = cnpjTitular;
    }

    @Column(name="DATA_BOM_PARA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataBomPara() {
        return this.dataBomPara;
    }

    public void setDataBomPara(Date dataBomPara) {
        this.dataBomPara = dataBomPara;
    }

    @Column(name="C1_C2_C3", length=3)
    public String getC1c2c3() {
        return this.c1c2c3;
    }

    public void setC1c2c3(String c1c2c3) {
        this.c1c2c3 = c1c2c3;
    }

    @Column(name="SERIAL_FOR_SINC", length=100)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_CHEQUE_DE_TERCEIROS_CLAS_PES"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }
}

