/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.ClienteFaturamento;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceira;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.ClienteNFCe;
import com.touchcomp.basementor.model.vo.ClienteNFCeMeioPagamento;
import com.touchcomp.basementor.model.vo.ClienteVeiculo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocIndicativoContPrevidenciario;
import com.touchcomp.basementor.model.vo.GrupoClientesRelCli;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Regiao;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CLIENTE")
public class Cliente
implements InterfaceVO {
    private PlanoConta planoConta;
    private PlanoConta planoContaAntecip;
    private Empresa empresa;
    private Date dataCadastro;
    private ClienteFichaFinanceira fichaFinanceira;
    private ClienteFinanceiro financeiro;
    private ClienteFaturamento faturamento;
    private Pessoa pessoa;
    private Long identificador;
    private Timestamp dataAtualizacao;
    private List<UnidadeFatCliente> unidadeFatClientes;
    private ClassificacaoClientes classificacaoClientes;
    private Regiao regiao;
    private String inscricaoProdutorRural;
    private String codigoCliente;
    private List<GrupoClientesRelCli> grupoClientes;
    private List<ClienteNFCe> clienteNFCe;
    private List<ClienteVeiculo> veiculos;
    private List<ClienteNFCeMeioPagamento> clienteNFCeMeioPagamento;
    private Date dataUltModificacao;
    private Short ativo;
    private EsocIndicativoContPrevidenciario esocIndicativoContPrev;
    private String codigoSincronizacao;
    private String codigoSincronizacao2;
    private Date dataAtualizacaoSevTerc;
    private Short codProvServicoRec;

    public Cliente() {
        this.unidadeFatClientes = new ArrayList<UnidadeFatCliente>();
        this.grupoClientes = new ArrayList<GrupoClientesRelCli>();
        this.veiculos = new ArrayList<ClienteVeiculo>();
        this.clienteNFCe = new ArrayList<ClienteNFCe>();
        this.clienteNFCeMeioPagamento = new ArrayList<ClienteNFCeMeioPagamento>();
        this.ativo = EnumConstantsMentorSimNao.SIM.value;
        this.codProvServicoRec = EnumConstProvedorRecAgro.SEM_VINCULO_SERVICO.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CLIENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLIENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIAO", foreignKey=@ForeignKey(name="FK_CLIENTE_REGIAO"))
    public Regiao getRegiao() {
        return this.regiao;
    }

    public void setRegiao(Regiao regiao) {
        this.regiao = regiao;
    }

    public Cliente(Long identificador, Pessoa p) {
        this.setIdentificador(identificador);
        this.setPessoa(p);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CLIENTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_CLIENTE_FICHA_FINANCEIRA")
    public ClienteFichaFinanceira getFichaFinanceira() {
        return this.fichaFinanceira;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_CLIENTE_FINANCEIRO")
    public ClienteFinanceiro getFinanceiro() {
        return this.financeiro;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_CLIENTE_FATURAMENTO")
    public ClienteFaturamento getFaturamento() {
        return this.faturamento;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setFichaFinanceira(ClienteFichaFinanceira fichaFinanceira) {
        this.fichaFinanceira = fichaFinanceira;
    }

    public void setFinanceiro(ClienteFinanceiro financeiro) {
        this.financeiro = financeiro;
    }

    public void setFaturamento(ClienteFaturamento faturamento) {
        this.faturamento = faturamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CLIENTE_PESSOA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @OneToMany(cascade={CascadeType.ALL, CascadeType.REMOVE}, mappedBy="cliente")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.REMOVE})
    public List<UnidadeFatCliente> getUnidadeFatClientes() {
        return this.unidadeFatClientes;
    }

    public void setUnidadeFatClientes(List<UnidadeFatCliente> unidadeFatClientes) {
        this.unidadeFatClientes = unidadeFatClientes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTES", foreignKey=@ForeignKey(name="FK_CLIENTE_CLASS_CLIENTES"))
    public ClassificacaoClientes getClassificacaoClientes() {
        return this.classificacaoClientes;
    }

    public void setClassificacaoClientes(ClassificacaoClientes classificacaoClientes) {
        this.classificacaoClientes = classificacaoClientes;
    }

    @Column(name="INSCRICAO_PRODUTOR_RURAL", length=15)
    public String getInscricaoProdutorRural() {
        return this.inscricaoProdutorRural;
    }

    public void setInscricaoProdutorRural(String inscricaoProdutorRural) {
        this.inscricaoProdutorRural = inscricaoProdutorRural;
    }

    @Column(name="CODIGO_CLIENTE", length=25)
    public String getCodigoCliente() {
        return this.codigoCliente;
    }

    public void setCodigoCliente(String codigoCliente) {
        this.codigoCliente = codigoCliente;
    }

    @OneToMany(mappedBy="cliente")
    public List<GrupoClientesRelCli> getGrupoClientes() {
        return this.grupoClientes;
    }

    public void setGrupoClientes(List<GrupoClientesRelCli> grupoClientes) {
        this.grupoClientes = grupoClientes;
    }

    @OneToMany(cascade={CascadeType.ALL, CascadeType.REMOVE}, mappedBy="cliente")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.REMOVE})
    public List<ClienteNFCe> getClienteNFCe() {
        return this.clienteNFCe;
    }

    public void setClienteNFCe(List<ClienteNFCe> clienteNFCe) {
        this.clienteNFCe = clienteNFCe;
    }

    @OneToMany(mappedBy="cliente")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.REMOVE})
    public List<ClienteVeiculo> getVeiculos() {
        return this.veiculos;
    }

    public void setVeiculos(List<ClienteVeiculo> veiculos) {
        this.veiculos = veiculos;
    }

    @OneToMany(cascade={CascadeType.ALL, CascadeType.REMOVE}, mappedBy="cliente")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.REMOVE})
    public List<ClienteNFCeMeioPagamento> getClienteNFCeMeioPagamento() {
        return this.clienteNFCeMeioPagamento;
    }

    public void setClienteNFCeMeioPagamento(List<ClienteNFCeMeioPagamento> clienteNFCeMeioPagamento) {
        this.clienteNFCeMeioPagamento = clienteNFCeMeioPagamento;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ULT_MODIFICACAO")
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_IND_CONT_PREV", foreignKey=@ForeignKey(name="FK_ESOC_IND_CONT_CLIENTE"))
    public EsocIndicativoContPrevidenciario getEsocIndicativoContPrev() {
        return this.esocIndicativoContPrev;
    }

    public void setEsocIndicativoContPrev(EsocIndicativoContPrevidenciario esocIndicativoContPrev) {
        this.esocIndicativoContPrev = esocIndicativoContPrev;
    }

    @Column(name="CODIGO_SINCRONIZACAO", length=100)
    public String getCodigoSincronizacao() {
        return this.codigoSincronizacao;
    }

    public void setCodigoSincronizacao(String codigoSincronizacao) {
        this.codigoSincronizacao = codigoSincronizacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO_SERV_TERC")
    public Date getDataAtualizacaoSevTerc() {
        return this.dataAtualizacaoSevTerc;
    }

    public void setDataAtualizacaoSevTerc(Date dataAtualizacaoSevTerc) {
        this.dataAtualizacaoSevTerc = dataAtualizacaoSevTerc;
    }

    @Column(name="COD_PROV_SERVICO_REC")
    public Short getCodProvServicoRec() {
        return this.codProvServicoRec;
    }

    public void setCodProvServicoRec(Short codProvServicoRec) {
        this.codProvServicoRec = codProvServicoRec;
    }

    @Column(name="CODIGO_SINCRONIZACAO_2", length=100)
    public String getCodigoSincronizacao2() {
        return this.codigoSincronizacao2;
    }

    public void setCodigoSincronizacao2(String codigoSincronizacao2) {
        this.codigoSincronizacao2 = codigoSincronizacao2;
    }
}

