/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaCbsIbs;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.RamoAtividade;
import com.touchcomp.basementor.model.vo.RegiaoTabPrecoDinamica;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoContribuinteCbsIbs;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.basementortools.tools.vo.equals.IdProperty;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CLIENTE_FATURAMENTO")
@IdProperty(name="idCliente")
public class ClienteFaturamento
implements InterfaceVO {
    private Long idCliente;
    private TipoFrete tipoFrete;
    private String observacaoPedido;
    private Transportador transportadora;
    private TransportadorRedespacho transportadoraRedespacho;
    private Representante representante;
    private CondicoesPagamento condicaoPagamento;
    private Cliente cliente;
    private RamoAtividade ramoAtividade;
    private Integer contribuicaoMunicipio = 0;
    private Double percentualPisSufr = 0.0;
    private Double percentualCofinsSufr = 0.0;
    private Double percentualIcmsSufr = 0.0;
    private Double percentualIpiSufr = 0.0;
    private CategoriaPessoa categoriaPessoa;
    private Short tipoConsumidor = 0;
    private RegiaoTabPrecoDinamica regiaoTabPrecoDinamica;
    private Integer numDiasVencimento = 0;
    private Short utilizarParamNomeclaturaProdutoXML = 0;
    private Timestamp dataAtualizacao;
    private String observacaoFaturamento;
    private CategoriaCbsIbs categoriaCbsIbs;
    private TipoContribuinteCbsIbs tipoContribuinteCbsIbs;

    @Id
    @Column(name="ID_CLIENTE_FATURAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLIENTE_FATURAMENTO")
    public Long getIdCliente() {
        return this.idCliente;
    }

    @Column(name="OBSERVACAO_PEDIDO", length=1000)
    public String getObservacaoPedido() {
        return this.observacaoPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_TRANSPOR"))
    public Transportador getTransportadora() {
        return this.transportadora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_REDESPACHO", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_TRANS_RE"))
    public TransportadorRedespacho getTransportadoraRedespacho() {
        return this.transportadoraRedespacho;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_REPRESEN"))
    public Representante getRepresentante() {
        return this.representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_COND_PAG"))
    public CondicoesPagamento getCondicaoPagamento() {
        return this.condicaoPagamento;
    }

    @OneToOne(mappedBy="faturamento")
    public Cliente getCliente() {
        return this.cliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RAMO_ATIVIDADE", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_RAM_ATIV"))
    public RamoAtividade getRamoAtividade() {
        return this.ramoAtividade;
    }

    @Column(name="CONTRIBUICAO_MUNICIPIO")
    public Integer getContribuicaoMunicipio() {
        return this.contribuicaoMunicipio;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public void setIdCliente(Long idCliente) {
        this.idCliente = idCliente;
    }

    public void setObservacaoPedido(String observacaoPedido) {
        this.observacaoPedido = observacaoPedido;
    }

    public void setTransportadora(Transportador idTransp) {
        this.transportadora = idTransp;
    }

    public void setTransportadoraRedespacho(TransportadorRedespacho idTranspRedespacho) {
        this.transportadoraRedespacho = idTranspRedespacho;
    }

    public void setRepresentante(Representante idRepresentante) {
        this.representante = idRepresentante;
    }

    public void setCondicaoPagamento(CondicoesPagamento idCondPg) {
        this.condicaoPagamento = idCondPg;
    }

    public void setRamoAtividade(RamoAtividade ramo) {
        this.ramoAtividade = ramo;
    }

    public void setContribuicaoMunicipio(Integer contribMunicipio) {
        this.contribuicaoMunicipio = contribMunicipio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_CAT_PESS"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_TP_FRETE"))
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="PERCENTUAL_PIS_SUFR", precision=15, scale=2)
    public Double getPercentualPisSufr() {
        return this.percentualPisSufr;
    }

    public void setPercentualPisSufr(Double percentualPis) {
        this.percentualPisSufr = percentualPis;
    }

    @Column(nullable=false, name="PERCENTUAL_COFINS_SUFR", precision=15, scale=2)
    public Double getPercentualCofinsSufr() {
        return this.percentualCofinsSufr;
    }

    public void setPercentualCofinsSufr(Double percentualCofins) {
        this.percentualCofinsSufr = percentualCofins;
    }

    @Column(name="PERCENTUAL_ICMS_SUFR", precision=15, scale=2)
    public Double getPercentualIcmsSufr() {
        return this.percentualIcmsSufr;
    }

    public void setPercentualIcmsSufr(Double percentualIcms) {
        this.percentualIcmsSufr = percentualIcms;
    }

    @Column(nullable=false, name="PERCENTUAL_IPI_SUFR", precision=15, scale=2)
    public Double getPercentualIpiSufr() {
        return this.percentualIpiSufr;
    }

    public void setPercentualIpiSufr(Double percentualIpi) {
        this.percentualIpiSufr = percentualIpi;
    }

    @Column(name="TIPO_CONSUMIDOR")
    public Short getTipoConsumidor() {
        return this.tipoConsumidor;
    }

    public void setTipoConsumidor(Short tipoConsumidor) {
        this.tipoConsumidor = tipoConsumidor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIAO_TAB_PRECO_DINAMICA", foreignKey=@ForeignKey(name="FK_CLIENTE_FATURAMENTO_6"))
    public RegiaoTabPrecoDinamica getRegiaoTabPrecoDinamica() {
        return this.regiaoTabPrecoDinamica;
    }

    public void setRegiaoTabPrecoDinamica(RegiaoTabPrecoDinamica regiaoTabPrecoDinamica) {
        this.regiaoTabPrecoDinamica = regiaoTabPrecoDinamica;
    }

    @Column(name="NUM_DIAS_VENCIMENTO")
    public Integer getNumDiasVencimento() {
        return this.numDiasVencimento;
    }

    public void setNumDiasVencimento(Integer numDiasVencimento) {
        this.numDiasVencimento = numDiasVencimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdCliente(), this.getObservacaoPedido()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdCliente());
    }

    @Column(name="UTILIZAR_PARAM_NOME_PRODUTO_XML")
    public Short getUtilizarParamNomeclaturaProdutoXML() {
        return this.utilizarParamNomeclaturaProdutoXML;
    }

    public void setUtilizarParamNomeclaturaProdutoXML(Short utilizarParamNomeclaturaProdutoXML) {
        this.utilizarParamNomeclaturaProdutoXML = utilizarParamNomeclaturaProdutoXML;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="OBSERVACAO_FATURAMENTO", length=300)
    public String getObservacaoFaturamento() {
        return this.observacaoFaturamento;
    }

    public void setObservacaoFaturamento(String observacaoFaturamento) {
        this.observacaoFaturamento = observacaoFaturamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLIENTE_FAT_CAT_CBS_IBS"))
    public CategoriaCbsIbs getCategoriaCbsIbs() {
        return this.categoriaCbsIbs;
    }

    public void setCategoriaCbsIbs(CategoriaCbsIbs categoriaCbsIbs) {
        this.categoriaCbsIbs = categoriaCbsIbs;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONTRIB_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLI_FAT_TIPO_C_CBS_IBS"))
    public TipoContribuinteCbsIbs getTipoContribuinteCbsIbs() {
        return this.tipoContribuinteCbsIbs;
    }

    public void setTipoContribuinteCbsIbs(TipoContribuinteCbsIbs tipoContribuinteCbsIbs) {
        this.tipoContribuinteCbsIbs = tipoContribuinteCbsIbs;
    }
}

