/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceira;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="CLIENTE_FICHA_SOCIO_AUT")
public class ClienteFinanceiroSocioAutorizado
implements InterfaceVO {
    private Long identificador;
    private ClienteFichaFinanceira fichaFinanceira;
    private String nomeSocio = "";
    private String cnpjCpf = "";
    private String uf = "";
    private Date dataAutorizacao;
    private String telefone = "";
    private Double percCapital = 100.0;
    private Short administrativo = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_CLIENTE_FINANC_SOCIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLIENTE_FINANC_SOCIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FICHA_FINANCEIRA", foreignKey=@ForeignKey(name="FK_CLIENTE_FICHA_SOCIO_AUT_1"))
    public ClienteFichaFinanceira getFichaFinanceira() {
        return this.fichaFinanceira;
    }

    public void setFichaFinanceira(ClienteFichaFinanceira fichaFinanceira) {
        this.fichaFinanceira = fichaFinanceira;
    }

    @Column(name="NOME_SOCIO", length=100)
    public String getNomeSocio() {
        return this.nomeSocio;
    }

    public void setNomeSocio(String nomeSocio) {
        this.nomeSocio = nomeSocio;
    }

    @Column(name="CNPJ_CPF", length=40)
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Column(name="UF", length=20)
    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_AUTORIZACAO")
    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    @Column(name="TELEFONE", length=20)
    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Column(name="PERC_CAPITAL", precision=15, scale=2)
    public Double getPercCapital() {
        return this.percCapital;
    }

    public void setPercCapital(Double percCapital) {
        this.percCapital = percCapital;
    }

    @Column(name="ADMINISTRATIVO")
    public Short getAdministrativo() {
        return this.administrativo;
    }

    public void setAdministrativo(Short administrativo) {
        this.administrativo = administrativo;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ClienteFinanceiroSocioAutorizado)) {
            return false;
        }
        ClienteFinanceiroSocioAutorizado castOther = (ClienteFinanceiroSocioAutorizado)other;
        return new EqualsBuilder().append((Object)this.getIdentificador(), (Object)castOther.getIdentificador()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentificador()).toHashCode();
    }

    public String toString() {
        return this.nomeSocio;
    }
}

