/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.IntegracaoFinanceiroRh;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TitulosIntegracaoFinanceiro;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="COLABORADOR_INT_FINANCEIRO")
public class ColaboradorIntegracaoFinanceiro
implements Serializable {
    private Long identificador;
    private IntegracaoFinanceiroRh integracao;
    private Double valorTotalCompras;
    private Double valorMesAnterior;
    private Double valorProjetado;
    private MovimentoFolha movimentoFolha;
    private List<TitulosIntegracaoFinanceiro> titulos;

    public ColaboradorIntegracaoFinanceiro() {
        this.valorTotalCompras = 0.0;
        this.valorMesAnterior = 0.0;
        this.valorProjetado = 0.0;
        this.titulos = new ArrayList<TitulosIntegracaoFinanceiro>();
    }

    public ColaboradorIntegracaoFinanceiro(MovimentoFolha m) {
        this.movimentoFolha = m;
        this.valorTotalCompras = 0.0;
        this.valorMesAnterior = 0.0;
        this.valorProjetado = 0.0;
        this.titulos = new ArrayList<TitulosIntegracaoFinanceiro>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_COLABORADOR_INT_FINANCEIRO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COLABORADOR_INT_FINANCEIRO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_integracao")
    public IntegracaoFinanceiroRh getIntegracao() {
        return this.integracao;
    }

    public void setIntegracao(IntegracaoFinanceiroRh integracao) {
        this.integracao = integracao;
    }

    @Column(name="valor_total_Compras", precision=15, scale=2)
    public Double getValorTotalCompras() {
        return this.valorTotalCompras;
    }

    public void setValorTotalCompras(Double valorTotalCompras) {
        this.valorTotalCompras = valorTotalCompras;
    }

    @Column(name="valor_mes_anterior", precision=15, scale=2)
    public Double getValorMesAnterior() {
        return this.valorMesAnterior;
    }

    public void setValorMesAnterior(Double valorMesAnterior) {
        this.valorMesAnterior = valorMesAnterior;
    }

    @Column(name="valor_projetado", precision=15, scale=2)
    public Double getValorProjetado() {
        return this.valorProjetado;
    }

    public void setValorProjetado(Double valorProjetado) {
        this.valorProjetado = valorProjetado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="integracao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TitulosIntegracaoFinanceiro> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<TitulosIntegracaoFinanceiro> titulos) {
        this.titulos = titulos;
    }

    @JoinColumn(name="id_movimento_folha")
    @ManyToOne(fetch=FetchType.LAZY)
    public MovimentoFolha getMovimentoFolha() {
        return this.movimentoFolha;
    }

    public void setMovimentoFolha(MovimentoFolha movimentoFolha) {
        this.movimentoFolha = movimentoFolha;
    }
}

