/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtualizacaoSalarial;
import com.touchcomp.basementor.model.vo.CadastroConvencaoColetiva;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.TipoAlteracaoSalarial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="COLABORADOR_SALARIO")
public class ColaboradorSalario
implements InterfaceVO {
    private Long identificador;
    private Date periodo;
    private Double valorSalario = 0.0;
    private String observacao;
    private Date dataCadastro;
    private Colaborador colaborador;
    private AtualizacaoSalarial atualizacaoSalarial;
    private Timestamp dataAtualizacao;
    private Funcao funcao;
    private TipoAlteracaoSalarial alteracaoSalarial;
    private Double valorSalarioAnterior = 0.0;
    private Date periodoDataBase;
    private CadastroConvencaoColetiva convencao;
    private Double percAumento = 0.0;
    private CentroCusto centroCusto;

    @Id
    @Column(nullable=false, unique=true, name="ID_COLABORADOR_SALARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COLABORADOR_SALARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPeriodo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=100)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=false, name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(nullable=false, name="VALOR_SALARIO", precision=12, scale=2)
    public Double getValorSalario() {
        return this.valorSalario;
    }

    public void setValorSalario(Double valorSalario) {
        this.valorSalario = valorSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_SALARIO_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @JoinColumn(name="ID_ATUALIZACAO_SALARIAL", foreignKey=@ForeignKey(name="FK_COLABORADOR_SALARIO_AT_SAL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public AtualizacaoSalarial getAtualizacaoSalarial() {
        return this.atualizacaoSalarial;
    }

    public void setAtualizacaoSalarial(AtualizacaoSalarial atualizacaoSalarial) {
        this.atualizacaoSalarial = atualizacaoSalarial;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_SALARIO_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ALTERACAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_SALARIO_TP_ALTER"))
    public TipoAlteracaoSalarial getAlteracaoSalarial() {
        return this.alteracaoSalarial;
    }

    public void setAlteracaoSalarial(TipoAlteracaoSalarial alteracaoSalarial) {
        this.alteracaoSalarial = alteracaoSalarial;
    }

    @Column(name="VALOR_SALARIO_ANTERIOR", precision=15, scale=2)
    public Double getValorSalarioAnterior() {
        return this.valorSalarioAnterior;
    }

    public void setValorSalarioAnterior(Double valorSalarioAnterior) {
        this.valorSalarioAnterior = valorSalarioAnterior;
    }

    @Column(name="PERIODO_DATA_BASE")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoDataBase() {
        return this.periodoDataBase;
    }

    public void setPeriodoDataBase(Date periodoDataBase) {
        this.periodoDataBase = periodoDataBase;
    }

    @JoinColumn(name="ID_CONVENCAO", foreignKey=@ForeignKey(name="FK_SALARIO_CONVENCAO_COLETIVA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CadastroConvencaoColetiva getConvencao() {
        return this.convencao;
    }

    public void setConvencao(CadastroConvencaoColetiva convencao) {
        this.convencao = convencao;
    }

    @Column(name="PERC_AUMENTO", precision=15, scale=4)
    public Double getPercAumento() {
        return this.percAumento;
    }

    public void setPercAumento(Double percAumento) {
        this.percAumento = percAumento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_COLAB_SALARIO_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }
}

