/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.tipocompesacaocheque.EnumConstTipoCompesacaoCheque;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.GrupoCompensacao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="COMPENSACAO_CHEQUES")
public class CompensacaoCheque
implements InterfaceVO {
    private Long identificador;
    private Cheque cheque;
    private LoteContabil loteContabil;
    private GrupoCompensacao grupoCompensacao;
    private Date dataCompensacao;
    private MovimentoBancario movimentoBancario;
    private Short tipoCompensacao = EnumConstTipoCompesacaoCheque.NORMAL.getValue();

    @Id
    @Column(name="ID_COMPENSACAO_CHEQUES")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMPENSACAO_CHEQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_CHEQUE", foreignKey=@ForeignKey(name="FK_COMPENSACAO_CHEQUES_1"))
    @OneToOne(fetch=FetchType.LAZY)
    public Cheque getCheque() {
        return this.cheque;
    }

    public void setCheque(Cheque cheque) {
        this.cheque = cheque;
    }

    @Column(nullable=false, name="DATA_COMPENSACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCompensacao() {
        return this.dataCompensacao;
    }

    public void setDataCompensacao(Date dataCompensacao) {
        this.dataCompensacao = dataCompensacao;
    }

    @JoinColumn(name="ID_GRUPO_COMPENSACAO", foreignKey=@ForeignKey(name="FK_COMPENSACAO_CHEQUES_GRU_COMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoCompensacao getGrupoCompensacao() {
        return this.grupoCompensacao;
    }

    public void setGrupoCompensacao(GrupoCompensacao grupoCompensacao) {
        this.grupoCompensacao = grupoCompensacao;
    }

    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_COMPENSACAO_CHEQUES_LOTE_CON"))
    @OneToOne(targetEntity=LoteContabil.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getCheque() != null ? this.getCheque().getFavorecido() : this.getCheque()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_MOVIMENTO_BANCARIO", foreignKey=@ForeignKey(name="FK_COM_CHEQ_MOVI_BANCARIO"))
    @OneToOne(targetEntity=MovimentoBancario.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public MovimentoBancario getMovimentoBancario() {
        return this.movimentoBancario;
    }

    public void setMovimentoBancario(MovimentoBancario movimentoBancario) {
        this.movimentoBancario = movimentoBancario;
    }

    @Column(nullable=false, name="TIPO_COMPESACAO")
    public Short getTipoCompensacao() {
        return this.tipoCompensacao;
    }

    public void setTipoCompensacao(Short tipoCompensacao) {
        this.tipoCompensacao = tipoCompensacao;
    }
}

