/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConciliacaoBancaria;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ItemConciliacaoExtrato;
import com.touchcomp.basementor.model.vo.ItemConciliacaoMovimento;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONC_BANCARIA_DIA")
public class ConciliacaoBancariaDia
implements InterfaceVO {
    private Long identificador;
    private ConciliacaoBancaria conciliacaoBancaria;
    private List<ItemConciliacaoExtrato> itemConciliacaoExtrato = new ArrayList<ItemConciliacaoExtrato>();
    private List<ItemConciliacaoMovimento> itemConciliacaoMovimento = new ArrayList<ItemConciliacaoMovimento>();
    private Double valorSaldoAnteriorExtrato = 0.0;
    private Double valorSaldoAtualExtrato = 0.0;
    private Double valorDebitosExtrato = 0.0;
    private Double valorCreditosExtrato = 0.0;
    private Double valorSaldoAnteriorMov = 0.0;
    private Double valorSaldoAtualMov = 0.0;
    private Double valorDebitosMov = 0.0;
    private Double valorCreditosMov = 0.0;
    private Date dataMovimento;
    private ContaValores contaValores;

    @Id
    @Column(nullable=false, name="ID_CONC_BANCARIA_DIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONC_BANCARIA_DIA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONC_BANCARIA", foreignKey=@ForeignKey(name="FK_CONC_BANCARIA_DIA_CONC_BANC"))
    public ConciliacaoBancaria getConciliacaoBancaria() {
        return this.conciliacaoBancaria;
    }

    public void setConciliacaoBancaria(ConciliacaoBancaria conciliacaoBancaria) {
        this.conciliacaoBancaria = conciliacaoBancaria;
    }

    @OneToMany(mappedBy="conciliacaoBancariaDia", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemConciliacaoExtrato> getItemConciliacaoExtrato() {
        return this.itemConciliacaoExtrato;
    }

    public void setItemConciliacaoExtrato(List<ItemConciliacaoExtrato> itemConciliacaoExtrato) {
        this.itemConciliacaoExtrato = itemConciliacaoExtrato;
    }

    @Column(name="VR_SALDO_ANT_EXT", precision=15, scale=2)
    public Double getValorSaldoAnteriorExtrato() {
        return this.valorSaldoAnteriorExtrato;
    }

    public void setValorSaldoAnteriorExtrato(Double valorSaldoAnteriorExtrato) {
        this.valorSaldoAnteriorExtrato = valorSaldoAnteriorExtrato;
    }

    @Column(name="VR_SALDO_ATUAL_EXT", precision=15, scale=2)
    public Double getValorSaldoAtualExtrato() {
        return this.valorSaldoAtualExtrato;
    }

    public void setValorSaldoAtualExtrato(Double valorSaldoAtualExtrato) {
        this.valorSaldoAtualExtrato = valorSaldoAtualExtrato;
    }

    @Column(name="VR_DEBITO_EXT", precision=15, scale=2)
    public Double getValorDebitosExtrato() {
        return this.valorDebitosExtrato;
    }

    public void setValorDebitosExtrato(Double valorDebitosExtrato) {
        this.valorDebitosExtrato = valorDebitosExtrato;
    }

    @Column(name="VR_CREDITO_EXT", precision=15, scale=2)
    public Double getValorCreditosExtrato() {
        return this.valorCreditosExtrato;
    }

    public void setValorCreditosExtrato(Double valorCreditosExtrato) {
        this.valorCreditosExtrato = valorCreditosExtrato;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTO")
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    public void setDataMovimento(Date dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.getDataMovimento())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="conciliacaoBancariaDia", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemConciliacaoMovimento> getItemConciliacaoMovimento() {
        return this.itemConciliacaoMovimento;
    }

    public void setItemConciliacaoMovimento(List<ItemConciliacaoMovimento> itemConciliacaoMovimento) {
        this.itemConciliacaoMovimento = itemConciliacaoMovimento;
    }

    @Column(name="VR_SALDO_ANT_MOV", precision=15, scale=2)
    public Double getValorSaldoAnteriorMov() {
        return this.valorSaldoAnteriorMov;
    }

    public void setValorSaldoAnteriorMov(Double valorSaldoAnteriorMov) {
        this.valorSaldoAnteriorMov = valorSaldoAnteriorMov;
    }

    @Column(name="VR_SALDO_ATUAL_MOV", precision=15, scale=2)
    public Double getValorSaldoAtualMov() {
        return this.valorSaldoAtualMov;
    }

    public void setValorSaldoAtualMov(Double valorSaldoAtualMov) {
        this.valorSaldoAtualMov = valorSaldoAtualMov;
    }

    @Column(name="VR_DEBITO_MOV", precision=15, scale=2)
    public Double getValorDebitosMov() {
        return this.valorDebitosMov;
    }

    public void setValorDebitosMov(Double valorDebitosMov) {
        this.valorDebitosMov = valorDebitosMov;
    }

    @Column(name="VR_CREDITO_MOV", precision=15, scale=2)
    public Double getValorCreditosMov() {
        return this.valorCreditosMov;
    }

    public void setValorCreditosMov(Double valorCreditosMov) {
        this.valorCreditosMov = valorCreditosMov;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONTA_VALORES", foreignKey=@ForeignKey(name="FK_CONC_BANCARIA_DIA_CV"))
    public ContaValores getContaValores() {
        return this.contaValores;
    }

    public void setContaValores(ContaValores contaValores) {
        this.contaValores = contaValores;
    }
}

