/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConferenciaPedidoItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONFERENCIA_PEDIDO")
public class ConferenciaPedido
implements InterfaceVO {
    private Long identificador;
    private Pedido pedido;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuario;
    private List<ConferenciaPedidoItem> conferenciaPedidoItem = new ArrayList<ConferenciaPedidoItem>();
    private Short conferida = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_CONFERENCIA_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONFERENCIA_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_CONFERENCIA_PEDIDO_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONFERENCIA_PEDIDO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPedido() != null ? ToolBaseMethodsVO.toString((String)"{0} - Pedido: {1} - Unidade: {3}", (Object[])new Object[]{this.getIdentificador(), this.getPedido().getIdentificador(), this.getPedido().getUnidadeFatCliente()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CONFERENCIA_PEDIDO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="CONFERIDA")
    public Short getConferida() {
        return this.conferida;
    }

    public void setConferida(Short conferida) {
        this.conferida = conferida;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="conferenciaPedido", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ConferenciaPedidoItem> getConferenciaPedidoItem() {
        return this.conferenciaPedidoItem;
    }

    public void setConferenciaPedidoItem(List<ConferenciaPedidoItem> conferenciaPedidoItem) {
        this.conferenciaPedidoItem = conferenciaPedidoItem;
    }
}

