/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AutConsumoAtivo;
import com.touchcomp.basementor.model.vo.BombaCombustivel;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONSUMO_ATIVO")
public class ConsumoAtivo
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Requisicao requisicao;
    private Date dataMovimentacao;
    private String observacao;
    private Long nrDocOrigem;
    private OrdemServico ordemServico;
    private Double hodometro = 0.0;
    private Double hodometroAnterior = 0.0;
    private String codigoCTF;
    private Equipamento equipamento;
    private BombaCombustivel bombaCombustivel;
    private Pessoa solicitante;
    private List<ItemConsumoAtivo> itemConsumoAtivo = new ArrayList<ItemConsumoAtivo>();
    private Date dataConsumo;
    private AutConsumoAtivo autConsumoAtivo;
    private Short gerarColeta = EnumConstantsMentorSimNao.NAO.getValue();
    private TipoPontoControle tipoPontoControleColeta;
    private Timestamp dataHoraColeta;
    private Integer valorColeta = 0;
    private Coleta coleta;
    private Motorista motorista;
    private Short consumoGeradoProFrota = EnumConstantsMentorSimNao.NAO.getValue();

    @Id
    @Column(nullable=false, name="ID_CONSUMO_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONSUMO_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_REQUISICAO"))
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTACAO")
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="NR_DOC_ORIGEM")
    @Ignore
    public Long getNrDocOrigem() {
        return this.nrDocOrigem;
    }

    public void setNrDocOrigem(Long nrDocOrigem) {
        this.nrDocOrigem = nrDocOrigem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_ORDEM_SERV"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Column(nullable=false, name="HODOMETRO", precision=15, scale=6)
    public Double getHodometro() {
        return this.hodometro;
    }

    public void setHodometro(Double hodometro) {
        this.hodometro = hodometro;
    }

    @Column(nullable=false, name="HODOMETRO_ANTERIOR", precision=15, scale=6)
    public Double getHodometroAnterior() {
        return this.hodometroAnterior;
    }

    public void setHodometroAnterior(Double hodometroAnterior) {
        this.hodometroAnterior = hodometroAnterior;
    }

    @Column(name="CODIGO_CTF", length=10)
    public String getCodigoCTF() {
        return this.codigoCTF;
    }

    public void setCodigoCTF(String codigoCTF) {
        this.codigoCTF = codigoCTF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_EQUIPAMENTO"))
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BOMBA_COMBUSTIVEL", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_BOM_COMB"))
    public BombaCombustivel getBombaCombustivel() {
        return this.bombaCombustivel;
    }

    public void setBombaCombustivel(BombaCombustivel bombaCombustivel) {
        this.bombaCombustivel = bombaCombustivel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SOLICITANTE", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_SOLICITANTE"))
    public Pessoa getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Pessoa solicitante) {
        this.solicitante = solicitante;
    }

    @OneToMany(mappedBy="consumoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemConsumoAtivo> getItemConsumoAtivo() {
        return this.itemConsumoAtivo;
    }

    public void setItemConsumoAtivo(List<ItemConsumoAtivo> itemConsumoAtivo) {
        this.itemConsumoAtivo = itemConsumoAtivo;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CONSUMO")
    public Date getDataConsumo() {
        return this.dataConsumo;
    }

    public void setDataConsumo(Date dataConsumo) {
        this.dataConsumo = dataConsumo;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AUT_CONSUMO_ATIVO", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_AUT_CONS_ATIVO"))
    public AutConsumoAtivo getAutConsumoAtivo() {
        return this.autConsumoAtivo;
    }

    public void setAutConsumoAtivo(AutConsumoAtivo autConsumoAtivo) {
        this.autConsumoAtivo = autConsumoAtivo;
    }

    @Column(name="GERAR_COLETA")
    public Short getGerarColeta() {
        return this.gerarColeta;
    }

    public void setGerarColeta(Short gerarColeta) {
        this.gerarColeta = gerarColeta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_TIPO_PONTO_CON"))
    public TipoPontoControle getTipoPontoControleColeta() {
        return this.tipoPontoControleColeta;
    }

    public void setTipoPontoControleColeta(TipoPontoControle tipoPontoControleColeta) {
        this.tipoPontoControleColeta = tipoPontoControleColeta;
    }

    @Column(name="DATA_HORA_COLETA")
    public Timestamp getDataHoraColeta() {
        return this.dataHoraColeta;
    }

    public void setDataHoraColeta(Timestamp dataHoraColeta) {
        this.dataHoraColeta = dataHoraColeta;
    }

    @Column(name="VALOR_COLETA", precision=15, scale=0)
    public Integer getValorColeta() {
        return this.valorColeta;
    }

    public void setValorColeta(Integer valorColeta) {
        this.valorColeta = valorColeta;
    }

    @OneToOne(targetEntity=Coleta.class, optional=true, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_COLETA", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_COLETA"))
    public Coleta getColeta() {
        return this.coleta;
    }

    public void setColeta(Coleta coleta) {
        this.coleta = coleta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_CONSUMO_ATIVO_MOTORISTA"))
    public Motorista getMotorista() {
        return this.motorista;
    }

    public void setMotorista(Motorista motorista) {
        this.motorista = motorista;
    }

    @Column(name="CONSUMO_GERADO_PRO_FROTA")
    public Short getConsumoGeradoProFrota() {
        return this.consumoGeradoProFrota;
    }

    public void setConsumoGeradoProFrota(Short consumoGeradoProFrota) {
        this.consumoGeradoProFrota = consumoGeradoProFrota;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getEquipamento()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

