/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.EventoCobrancaLocacao;
import com.touchcomp.basementor.model.vo.ItemContratoLocacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONTRATO_LOCACAO_BEM")
public class ContratoLocacaoBem
implements InterfaceVO {
    private Long identificador;
    private Double valorTotal = 0.0;
    private Equipamento ativo;
    private List<EventoCobrancaLocacao> eventoCobrancaLocacao = new ArrayList<EventoCobrancaLocacao>();
    private Date dataInicial;
    private Date dataFinal;
    private Short statusAtivo = 0;
    private Timestamp dataAtualizacao;
    private ItemContratoLocacao itemContratoLocacao;

    @Id
    @Column(nullable=false, name="ID_CONTRATO_LOCACAO_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTRATO_LOCACAO_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=16, scale=6)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_BEM_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="contratoLocacaoBem", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL, CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH})
    public List<EventoCobrancaLocacao> getEventoCobrancaLocacao() {
        return this.eventoCobrancaLocacao;
    }

    public void setEventoCobrancaLocacao(List<EventoCobrancaLocacao> eventoCobrancaLocacao) {
        this.eventoCobrancaLocacao = eventoCobrancaLocacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getAtivo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="STATUS_ATIVO")
    public Short getStatusAtivo() {
        return this.statusAtivo;
    }

    public void setStatusAtivo(Short statusAtivo) {
        this.statusAtivo = statusAtivo;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_BEM_ID_ITEM"))
    public ItemContratoLocacao getItemContratoLocacao() {
        return this.itemContratoLocacao;
    }

    public void setItemContratoLocacao(ItemContratoLocacao itemContratoLocacao) {
        this.itemContratoLocacao = itemContratoLocacao;
    }
}

