/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.controleentregaequipamento.EnumConstControleEpiTipoOperacao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CONTROLE_ENTREGA_EQUIPAMENTO")
public class ControleEntregaEquipamento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Colaborador colaborador;
    private List<ItemControleEquipamento> itemControleEquipamentos = new ArrayList<ItemControleEquipamento>();
    private Date dataEntrega;
    private Usuario usuario;
    private Requisicao requisicao;
    private Short tipoOperacao = EnumConstControleEpiTipoOperacao.TIPO_OPERACAO_ENTREGA.getEnumId();
    private ImplantacaoSaldos implantacaoSaldos;

    @Id
    @Column(name="ID_CONTROLE_ENTREG_EQUIP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTR_ENTR_EQUIP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTR_ENTR_EQUIP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CONTR_ENTR_EQUIP_COLABORADO"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="controleEntregaEquipamento")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemControleEquipamento> getItemControleEquipamentos() {
        return this.itemControleEquipamentos;
    }

    public void setItemControleEquipamentos(List<ItemControleEquipamento> itemControleEquipamentos) {
        this.itemControleEquipamentos = itemControleEquipamentos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTREGA")
    public Date getDataEntrega() {
        return this.dataEntrega;
    }

    public void setDataEntrega(Date dataEntrega) {
        this.dataEntrega = dataEntrega;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_CONTR_ENTR_EQUIP_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @JoinColumn(name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_CONTROLE_ENT_EQUIP_REQ"))
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    @Column(name="TIPO_OPERACAO")
    public Short getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(Short tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="ID_IMPLANTACAO_SALDO", foreignKey=@ForeignKey(name="FK_CONTR_ENTR_EQUIP_IMPL_SALDO"))
    public ImplantacaoSaldos getImplantacaoSaldos() {
        return this.implantacaoSaldos;
    }

    public void setImplantacaoSaldos(ImplantacaoSaldos implantacaoSaldos) {
        this.implantacaoSaldos = implantacaoSaldos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getColaborador() != null ? this.getColaborador().getPessoa().getNome() : this.getColaborador(), this.getEmpresa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

