/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CartaoCooperado;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.LogStatusCooperado;
import com.touchcomp.basementor.model.vo.StatusCooperado;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="COOPERADO")
public class Cooperado
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Short ativo = 1;
    private Timestamp dataAtualizacao;
    private Cliente cliente;
    private String codigoCooperado;
    private Double aliquotaSenar = 0.0;
    private Double aliquotaRAT = 0.0;
    private Double aliquotaInss = 0.0;
    private TipoCooperado tipoCooperado;
    private StatusCooperado statusCooperado;
    private Short tipoRAT = 0;
    private Short tipoSenar = 0;
    private Short tipoInss = 0;
    private Short tipoTaxaSanidadeAnimal = 0;
    private List<LogStatusCooperado> logStatusCooperado = new ArrayList<LogStatusCooperado>();
    private Short numeroMatrizesCooperado = 0;
    private Short sexo = 1;
    private Double percComissao = 0.0;
    private List<CartaoCooperado> cartoesCooperados = new ArrayList<CartaoCooperado>();
    private String observacao;

    @Id
    @Column(name="ID_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_COOPERADO_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Column(name="CODIGO_COOPERADO", length=25)
    public String getCodigoCooperado() {
        return this.codigoCooperado;
    }

    public void setCodigoCooperado(String codigoCooperado) {
        this.codigoCooperado = codigoCooperado;
    }

    @Column(name="ALIQ_SENAR", precision=15, scale=6)
    public Double getAliquotaSenar() {
        return this.aliquotaSenar;
    }

    public void setAliquotaSenar(Double aliquotaSenar) {
        this.aliquotaSenar = aliquotaSenar;
    }

    @Column(nullable=false, name="ALIQ_RAT", precision=15, scale=6)
    public Double getAliquotaRAT() {
        return this.aliquotaRAT;
    }

    public void setAliquotaRAT(Double aliquotaRAT) {
        this.aliquotaRAT = aliquotaRAT;
    }

    @Column(nullable=false, name="ALIQ_INSS", precision=15, scale=6)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_COOPERADO", foreignKey=@ForeignKey(name="FK_COOPERADO_TIPO_COOPERADO"))
    public TipoCooperado getTipoCooperado() {
        return this.tipoCooperado;
    }

    public void setTipoCooperado(TipoCooperado tipoCooperado) {
        this.tipoCooperado = tipoCooperado;
    }

    @Column(name="TIPO_RAT")
    public Short getTipoRAT() {
        return this.tipoRAT;
    }

    public void setTipoRAT(Short tipoRAT) {
        this.tipoRAT = tipoRAT;
    }

    @Column(name="TIPO_SENAR")
    public Short getTipoSenar() {
        return this.tipoSenar;
    }

    public void setTipoSenar(Short tipoSenar) {
        this.tipoSenar = tipoSenar;
    }

    @Column(name="TIPO_INSS")
    public Short getTipoInss() {
        return this.tipoInss;
    }

    public void setTipoInss(Short tipoInss) {
        this.tipoInss = tipoInss;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigoCooperado(), this.getCliente() != null ? this.getCliente().getPessoa().getNome() : "Sem cliente"});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_COOPERADO", foreignKey=@ForeignKey(name="FK_COOPERADO_STATUS_COOPERADO"))
    public StatusCooperado getStatusCooperado() {
        return this.statusCooperado;
    }

    public void setStatusCooperado(StatusCooperado statusCooperado) {
        this.statusCooperado = statusCooperado;
    }

    @Column(name="TIPO_TAXA_SANIDADE_ANIMAL")
    public Short getTipoTaxaSanidadeAnimal() {
        return this.tipoTaxaSanidadeAnimal;
    }

    public void setTipoTaxaSanidadeAnimal(Short tipoTaxaSanidadeAnimal) {
        this.tipoTaxaSanidadeAnimal = tipoTaxaSanidadeAnimal;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cooperado", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LogStatusCooperado> getLogStatusCooperado() {
        return this.logStatusCooperado;
    }

    public void setLogStatusCooperado(List<LogStatusCooperado> logStatusCooperado) {
        this.logStatusCooperado = logStatusCooperado;
    }

    @Column(name="NUMERO_MATRIZES_COOPERADO")
    public Short getNumeroMatrizesCooperado() {
        return this.numeroMatrizesCooperado;
    }

    public void setNumeroMatrizesCooperado(Short numeroMatrizesCooperado) {
        this.numeroMatrizesCooperado = numeroMatrizesCooperado;
    }

    @Column(name="SEXO")
    public Short getSexo() {
        return this.sexo;
    }

    public void setSexo(Short sexo) {
        this.sexo = sexo;
    }

    @Column(name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @OneToMany(mappedBy="cooperado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CartaoCooperado> getCartoesCooperados() {
        return this.cartoesCooperados;
    }

    public void setCartoesCooperados(List<CartaoCooperado> cartoesCooperados) {
        this.cartoesCooperados = cartoesCooperados;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

