/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorCotacao;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="COTACAO")
public class Cotacao
implements InterfaceVO {
    private Long identificador;
    private Date dataCotacao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<OrdemCompra> ordemCompra = new ArrayList<OrdemCompra>();
    private List<FornecedorCotacao> fornecedorCotacao = new ArrayList<FornecedorCotacao>();

    @Id
    @Column(name="ID_COTACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COTACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="DATA_COTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCotacao() {
        return this.dataCotacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COTACAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cotacao")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @OrderColumn(name="indice")
    public List<FornecedorCotacao> getFornecedorCotacao() {
        return this.fornecedorCotacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @OneToMany(mappedBy="cotacao")
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE, CascadeType.DELETE_ORPHAN})
    public List<OrdemCompra> getOrdemCompra() {
        return this.ordemCompra;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCotacao(Date dataCotacao) {
        this.dataCotacao = dataCotacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setOrdemCompra(List<OrdemCompra> ordemCompra) {
        this.ordemCompra = ordemCompra;
    }

    public void setFornecedorCotacao(List<FornecedorCotacao> fornecedorCotacao) {
        this.fornecedorCotacao = fornecedorCotacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Cotacao numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

