/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LogCotacaoCompra;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="COTACAO_COMPRA")
public class CotacaoCompra
implements InterfaceVO {
    private Long identificador;
    private Short fechada = 0;
    private Date dataCadastro;
    private Date dataCotacaoCompra;
    private Date dataPrevFinalizacao;
    private Date dataFinalizacao;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuarioComprador;
    private List<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
    private List<ItemCotacaoCompra> itensCotacaoCompra = new ArrayList<ItemCotacaoCompra>();
    private String observacao;
    private SituacaoCotacaoCompra situacaoCotacaoCompra;
    private SituacaoCotacaoCompra situacaoCotacaoCompraAnt;
    private List<LogCotacaoCompra> logsCotacaoCompra = new ArrayList<LogCotacaoCompra>();

    @Id
    @Column(name="ID_COTACAO_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COTACAO_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="FECHADA")
    public Short getFechada() {
        return this.fechada;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COTACAO_COMPRA")
    public Date getDataCotacaoCompra() {
        return this.dataCotacaoCompra;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COTACAO_COMPRA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_COMPRADOR", foreignKey=@ForeignKey(name="FK_COTACAO_COMPRA_USUARIO"))
    public Usuario getUsuarioComprador() {
        return this.usuarioComprador;
    }

    @OneToMany(mappedBy="cotacaoCompra", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<OrdemCompra> getOrdensCompra() {
        return this.ordensCompra;
    }

    @OneToMany(mappedBy="cotacaoCompra", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE})
    public List<ItemCotacaoCompra> getItensCotacaoCompra() {
        return this.itensCotacaoCompra;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setFechada(Short fechada) {
        this.fechada = fechada;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataCotacaoCompra(Date dataCotacaoCompra) {
        this.dataCotacaoCompra = dataCotacaoCompra;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setUsuarioComprador(Usuario usuarioComprador) {
        this.usuarioComprador = usuarioComprador;
    }

    public void setOrdensCompra(List<OrdemCompra> ordensCompra) {
        this.ordensCompra = ordensCompra;
    }

    public void setItensCotacaoCompra(List<ItemCotacaoCompra> itensCotacaoCompra) {
        this.itensCotacaoCompra = itensCotacaoCompra;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Cotacao de Compra numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_COTACAO_COMPRA", foreignKey=@ForeignKey(name="FK_COTACAO_COMPRA_SIT_COT_COMP"))
    public SituacaoCotacaoCompra getSituacaoCotacaoCompra() {
        return this.situacaoCotacaoCompra;
    }

    public void setSituacaoCotacaoCompra(SituacaoCotacaoCompra situacaoCotacaoCompra) {
        this.situacaoCotacaoCompra = situacaoCotacaoCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_COTACAO_COMPRA_ANT", foreignKey=@ForeignKey(name="FK_COTACAO_COMPRA_SIT_COT_ANT"))
    public SituacaoCotacaoCompra getSituacaoCotacaoCompraAnt() {
        return this.situacaoCotacaoCompraAnt;
    }

    public void setSituacaoCotacaoCompraAnt(SituacaoCotacaoCompra situacaoCotacaoCompraAnt) {
        this.situacaoCotacaoCompraAnt = situacaoCotacaoCompraAnt;
    }

    @OneToMany(mappedBy="cotacaoCompra", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<LogCotacaoCompra> getLogsCotacaoCompra() {
        return this.logsCotacaoCompra;
    }

    public void setLogsCotacaoCompra(List<LogCotacaoCompra> logsCotacaoCompra) {
        this.logsCotacaoCompra = logsCotacaoCompra;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREV_FINALIZACAO")
    public Date getDataPrevFinalizacao() {
        return this.dataPrevFinalizacao;
    }

    public void setDataPrevFinalizacao(Date dataPrevFinalizacao) {
        this.dataPrevFinalizacao = dataPrevFinalizacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINALIZACAO")
    public Date getDataFinalizacao() {
        return this.dataFinalizacao;
    }

    public void setDataFinalizacao(Date dataFinalizacao) {
        this.dataFinalizacao = dataFinalizacao;
    }
}

