/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AverbacaoCte;
import com.touchcomp.basementor.model.vo.BloqueioCTe;
import com.touchcomp.basementor.model.vo.CTeAutDownloadXML;
import com.touchcomp.basementor.model.vo.CTeInfo;
import com.touchcomp.basementor.model.vo.CTeNFe;
import com.touchcomp.basementor.model.vo.CTeOutros;
import com.touchcomp.basementor.model.vo.CTeServVincMultimodal;
import com.touchcomp.basementor.model.vo.CTeVeiculosTransportados;
import com.touchcomp.basementor.model.vo.CancelamentoCte;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.CteAquaviario;
import com.touchcomp.basementor.model.vo.CteInfCarga;
import com.touchcomp.basementor.model.vo.CteLacres;
import com.touchcomp.basementor.model.vo.CteNf;
import com.touchcomp.basementor.model.vo.CteNfPagtoTranspAgregado;
import com.touchcomp.basementor.model.vo.CteOnu;
import com.touchcomp.basementor.model.vo.CteOrdemColeta;
import com.touchcomp.basementor.model.vo.CteSeguro;
import com.touchcomp.basementor.model.vo.CteVlrImpostos;
import com.touchcomp.basementor.model.vo.Ctrc;
import com.touchcomp.basementor.model.vo.EmissorDocAntCTe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoColetaCTe;
import com.touchcomp.basementor.model.vo.EnderecoEntregaCTe;
import com.touchcomp.basementor.model.vo.ErroAverbacaoCte;
import com.touchcomp.basementor.model.vo.EvtCTeCancelamento;
import com.touchcomp.basementor.model.vo.EvtCTeCartaCorrecao;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.FormaPagtoCte;
import com.touchcomp.basementor.model.vo.ItemClienteTomDiariasCte;
import com.touchcomp.basementor.model.vo.ItemCte;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteFaturamentoCTe;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalCte;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.ObservacaoEstNota;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoCTe;
import com.touchcomp.basementor.model.vo.ProgramacaoViagens;
import com.touchcomp.basementor.model.vo.RecargaCartaoValePed;
import com.touchcomp.basementor.model.vo.RemetenteDestinatarioFrete;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.TipoCTE;
import com.touchcomp.basementor.model.vo.TipoModal;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.TipoOperacaoCte;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.VersaoCTe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_CTE", columnNames={"SERIE", "NUMERO", "ID_MODELO_DOC_FISCAL", "ID_EMPRESA"})})
public class Cte
implements InterfaceVO {
    private Long identificador;
    private String chaveCte;
    private String chaveCteInf;
    private FormaPagtoCte formaPagtoCte;
    private String serie;
    private Long numero;
    private ModeloFiscalCte modeloFiscalCte;
    private Long numeroInformado;
    private Date dataEmissao;
    private Date horaSaida;
    private NaturezaOperacao naturezaOperacao;
    private Integer digitoVerificador = 0;
    private Integer digitoVerificadorInf;
    private TipoCTE tipoCte;
    private UnidadeFatCliente clienteTomador;
    private RemetenteDestinatarioFrete remetenteDestinatario;
    private UnidadeFatTransporte unidadeFatTransporteExpedidor;
    private UnidadeFatTransporte unidadeFatTransporteRecebedor;
    private List<ItemCte> itemCte;
    private Short tipoInfCte = 0;
    private List<CteNf> cteNf = new ArrayList<CteNf>();
    private List<CTeNFe> cteNfe = new ArrayList<CTeNFe>();
    private CteInfCarga cteInfCarga;
    private List<CTeOutros> cteOutros = new ArrayList<CTeOutros>();
    private List<ObservacaoEstNota> observacaoEstNota;
    private List<ObservacaoEstNota> observacaoIntFisco;
    private List<CteSeguro> cteSeguro = new ArrayList<CteSeguro>();
    private List<CteLacres> cteLacres = new ArrayList<CteLacres>();
    private List<CteOrdemColeta> cteOrdemColeta;
    private List<CteOnu> cteOnu;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private TipoOperacao tipoOperacaoFrete;
    private Short indicadorRetira = 0;
    private Date dataPrevEntrega;
    private Short indicadorLotacao = 0;
    private SituacaoDocumento situacaoDocumento;
    private ModeloDocFiscal modeloDocFiscal;
    private List<LivroFiscal> livrosFiscais;
    private LoteFaturamentoCTe loteFaturamentoCTe;
    private CTeInfo cteInfo;
    private Integer codChaveAcesso = 0;
    private String cnpj;
    private Short codUF = 0;
    private Short indicadorTipoFrete = 0;
    private Ctrc ctrc;
    private FaturaCte faturaCte;
    private ConjuntoTransportador conjuntoTransportador;
    private String chaveCteAuxiliar;
    private VersaoCTe versaoCte;
    private PeriodoEmissaoCTe periodoEmissaoCte;
    private Cfop cfop;
    private UnidadeFederativa unidadeFedFiscal;
    private CteVlrImpostos cteVlrImpostos;
    private LoteContabil loteContabilFat;
    private LoteContabil loteContabilGerFat;
    private String observacaoGeral;
    private List<RecargaCartaoValePed> recargasValePedagio;
    private Double vrTotalNotas = 0.0;
    private Double vrTotalVolumesNfes = 0.0;
    private Double pesoTotalNfes = 0.0;
    private Cte cteComplementar;
    private String chaveComplementar;
    private String infAdFiscoCteComp;
    private List<EmissorDocAntCTe> emissorDocAntCTe;
    private TipoOperacaoCte tipoOperacaoCte;
    private EnderecoColetaCTe enderecoColetaCTe;
    private EnderecoEntregaCTe enderecoEntregaCTe;
    private CteNfPagtoTranspAgregado cteNfTranspAgregado;
    private ItemClienteTomDiariasCte itemClienteTomDiariasCte;
    private BloqueioCTe bloqueioCte;
    private TabelaCalculoFrete tabelaCalculoFrete;
    private Short informarCompManuais = 0;
    private Representante representante;
    private TransportadorAgregado transportadorAgregado;
    private List<AverbacaoCte> averbacaoCte;
    private ErroAverbacaoCte erroAverbacaoCte;
    private CancelamentoCte cancelamentoCTe;
    private EvtCTeCancelamento evtCTeCancelamento;
    private List<EvtCTeCartaCorrecao> evtCTeCartaCorrecao;
    private Short informarCargaManuais = 0;
    private Date dataPrevViagem;
    private List<CTeAutDownloadXML> cteDownloadXML;
    private Short bloquearFatura = 0;
    private Cte cteAnulacao;
    private String chaveCteAnulacao;
    private Date dataDeclaracao;
    private Cte cteSubstituicaoOriginal;
    private String chaveCteSubstituicao;
    private Cte cteSubstituicaoAnulacao;
    private String chaveSubstituicaoNfe;
    private String chaveSubstituicaoCte;
    private List<Titulo> titulos;
    private Short gerarAverbacao = 1;
    private Short statusStratum = 0;
    private Short enviarCteStratum = 1;
    private String protocoloRastreamento;
    private Usuario usuarioCriacao;
    private Timestamp dataCriacao;
    private Cidade cidadeInicio;
    private Cidade cidadeFim;
    private Short gerarManifestoAut = 1;
    private ProgramacaoViagens programacaoViagens;
    private String numeroAverbacao;
    private Short aprovadoAverbacao = 0;
    private Short canceladoAverbacao = 0;
    private TipoModal modalCte;
    private CteAquaviario cteAquaviario;
    private List<CTeVeiculosTransportados> cteVeiculosTransportados;
    private List<CTeServVincMultimodal> cteServVincMultimodal;
    private Short indCteGlobalizado = 0;
    private Short informarDadosReformaTributaria = 1;
    private ParamTribCbsIbsClass paramTribCbsIbsClass;

    public Cte() {
        this.itemCte = new ArrayList<ItemCte>();
        this.recargasValePedagio = new ArrayList<RecargaCartaoValePed>();
        this.cteOrdemColeta = new ArrayList<CteOrdemColeta>();
        this.livrosFiscais = new ArrayList<LivroFiscal>();
        this.cteOnu = new ArrayList<CteOnu>();
        this.observacaoEstNota = new ArrayList<ObservacaoEstNota>();
        this.observacaoIntFisco = new ArrayList<ObservacaoEstNota>();
        this.emissorDocAntCTe = new ArrayList<EmissorDocAntCTe>();
        this.cteDownloadXML = new ArrayList<CTeAutDownloadXML>();
        this.titulos = new ArrayList<Titulo>();
        this.averbacaoCte = new ArrayList<AverbacaoCte>();
        this.evtCTeCartaCorrecao = new ArrayList<EvtCTeCartaCorrecao>();
        this.cteVeiculosTransportados = new ArrayList<CTeVeiculosTransportados>();
        this.cteServVincMultimodal = new ArrayList<CTeServVincMultimodal>();
    }

    @Id
    @Column(name="ID_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="CHAVE_CTE", length=44)
    public String getChaveCte() {
        return this.chaveCte;
    }

    public void setChaveCte(String chaveCte) {
        this.chaveCte = chaveCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMA_PAGAMENTO_CTE", foreignKey=@ForeignKey(name="FK_CTE_FORM_PAG_CTE"))
    public FormaPagtoCte getFormaPagtoCte() {
        return this.formaPagtoCte;
    }

    public void setFormaPagtoCte(FormaPagtoCte formaPagtoCte) {
        this.formaPagtoCte = formaPagtoCte;
    }

    @Column(name="SERIE", length=10)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="NUMERO")
    @Generated(value=GenerationTime.ALWAYS)
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CTE", foreignKey=@ForeignKey(name="FK_CTE_TIPO_CTE_"))
    public TipoCTE getTipoCte() {
        return this.tipoCte;
    }

    public void setTipoCte(TipoCTE tipoCte) {
        this.tipoCte = tipoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE_TOMADOR", foreignKey=@ForeignKey(name="FK_CTE_CLIENTE_TOMADOR"))
    public UnidadeFatCliente getClienteTomador() {
        return this.clienteTomador;
    }

    public void setClienteTomador(UnidadeFatCliente clienteTomador) {
        this.clienteTomador = clienteTomador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REMETENTE_DESTINATARIO", foreignKey=@ForeignKey(name="FK_CTE_REM_DESTINATARIO"))
    public RemetenteDestinatarioFrete getRemetenteDestinatario() {
        return this.remetenteDestinatario;
    }

    public void setRemetenteDestinatario(RemetenteDestinatarioFrete remetenteDestinatario) {
        this.remetenteDestinatario = remetenteDestinatario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TRANSP_EXPEDIDOR", foreignKey=@ForeignKey(name="FK_CTE_UNID_FAT_EXPEDIDOR"))
    public UnidadeFatTransporte getUnidadeFatTransporteExpedidor() {
        return this.unidadeFatTransporteExpedidor;
    }

    public void setUnidadeFatTransporteExpedidor(UnidadeFatTransporte unidadeFatTransporteExpedidor) {
        this.unidadeFatTransporteExpedidor = unidadeFatTransporteExpedidor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TRANSP_RECEBEDOR", foreignKey=@ForeignKey(name="FK_CTE_UNID_FAT_RECEBEDOR"))
    public UnidadeFatTransporte getUnidadeFatTransporteRecebedor() {
        return this.unidadeFatTransporteRecebedor;
    }

    public void setUnidadeFatTransporteRecebedor(UnidadeFatTransporte unidadeFatTransporteRecebedor) {
        this.unidadeFatTransporteRecebedor = unidadeFatTransporteRecebedor;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CteNf> getCteNf() {
        return this.cteNf;
    }

    public void setCteNf(List<CteNf> cteNf) {
        this.cteNf = cteNf;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemCte> getItemCte() {
        return this.itemCte;
    }

    public void setItemCte(List<ItemCte> itemCte) {
        this.itemCte = itemCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
        if (empresa != null && empresa.getPessoa() != null && empresa.getPessoa().getComplemento() != null && empresa.getPessoa().getComplemento().getCnpj() != null) {
            this.setCnpj(empresa.getPessoa().getComplemento().getCnpj());
            if (empresa.getPessoa().getEndereco() != null && empresa.getPessoa().getEndereco().getCidade() != null && empresa.getPessoa().getEndereco().getCidade().getUf() != null) {
                this.setCodUF(Short.valueOf(empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge()));
            }
        }
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(targetEntity=ObservacaoEstNota.class, cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="CTE_OBSERVACOES", joinColumns={@JoinColumn(name="ID_CTE")}, inverseJoinColumns={@JoinColumn(name="ID_OBSERVACAO_ESTNOTA")})
    public List<ObservacaoEstNota> getObservacaoEstNota() {
        return this.observacaoEstNota;
    }

    public void setObservacaoEstNota(List<ObservacaoEstNota> observacaoEstNota) {
        this.observacaoEstNota = observacaoEstNota;
    }

    @Column(name="INDICADOR_RETIRA")
    public Short getIndicadorRetira() {
        return this.indicadorRetira;
    }

    public void setIndicadorRetira(Short indicadorRetira) {
        this.indicadorRetira = indicadorRetira;
    }

    @Column(name="DATA_PREV_ENTREGA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevEntrega() {
        return this.dataPrevEntrega;
    }

    public void setDataPrevEntrega(Date dataPrevEntrega) {
        this.dataPrevEntrega = dataPrevEntrega;
    }

    @Column(name="INDICADOR_LOTACAO")
    public Short getIndicadorLotacao() {
        return this.indicadorLotacao;
    }

    public void setIndicadorLotacao(Short indicadorLotacao) {
        this.indicadorLotacao = indicadorLotacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumero()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(targetEntity=LivroFiscal.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="CTE_LIVROS_FISCAIS", joinColumns={@JoinColumn(name="ID_CTE")}, inverseJoinColumns={@JoinColumn(name="id_livro_fiscal")})
    public List<LivroFiscal> getLivrosFiscais() {
        return this.livrosFiscais;
    }

    public void setLivrosFiscais(List<LivroFiscal> livrosFiscais) {
        this.livrosFiscais = livrosFiscais;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPERACAO_FRETE", foreignKey=@ForeignKey(name="FK_CTE_TP_OPER_FRETE"))
    public TipoOperacao getTipoOperacaoFrete() {
        return this.tipoOperacaoFrete;
    }

    public void setTipoOperacaoFrete(TipoOperacao tipoOperacaoFrete) {
        this.tipoOperacaoFrete = tipoOperacaoFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FATURAMENTO_CTE", foreignKey=@ForeignKey(name="FK_CTE_LOTE_FAT_CTE"))
    public LoteFaturamentoCTe getLoteFaturamentoCTe() {
        return this.loteFaturamentoCTe;
    }

    public void setLoteFaturamentoCTe(LoteFaturamentoCTe loteFaturamentoCTe) {
        this.loteFaturamentoCTe = loteFaturamentoCTe;
    }

    @OneToOne(targetEntity=CTeInfo.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_CTE_INFO", foreignKey=@ForeignKey(name="FK_CTE_CTE_INFO"))
    public CTeInfo getCteInfo() {
        return this.cteInfo;
    }

    public void setCteInfo(CTeInfo cteInfo) {
        this.cteInfo = cteInfo;
    }

    @Column(name="CNPJ", length=18)
    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Column(name="CODIGO_UF")
    public Short getCodUF() {
        return this.codUF;
    }

    public void setCodUF(Short codUF) {
        this.codUF = codUF;
    }

    @Column(name="COD_ACESSO")
    public Integer getCodChaveAcesso() {
        return this.codChaveAcesso;
    }

    public void setCodChaveAcesso(Integer codChaveAcesso) {
        this.codChaveAcesso = codChaveAcesso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_CTE_SITUACAO_DOCUMENTO"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_CTE_MODELO_DOC_FISCAL"))
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.JOIN)
    public Ctrc getCtrc() {
        return this.ctrc;
    }

    public void setCtrc(Ctrc ctrc) {
        this.ctrc = ctrc;
    }

    @Column(name="IND_TIPO_FRETE")
    public Short getIndicadorTipoFrete() {
        return this.indicadorTipoFrete;
    }

    public void setIndicadorTipoFrete(Short indicadorTipoFrete) {
        this.indicadorTipoFrete = indicadorTipoFrete;
    }

    @Column(name="HORA_SAIDA")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraSaida() {
        return this.horaSaida;
    }

    public void setHoraSaida(Date horaSaida) {
        this.horaSaida = horaSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FATURA_CTE", foreignKey=@ForeignKey(name="FK_CTE_FATURA_CTE"))
    public FaturaCte getFaturaCte() {
        return this.faturaCte;
    }

    public void setFaturaCte(FaturaCte faturaCte) {
        this.faturaCte = faturaCte;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DIGITO_VERIFICADOR")
    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer digitoVerificador) {
        this.digitoVerificador = digitoVerificador;
    }

    @Ignore
    @Column(name="NUMERO_INFORMADO")
    public Long getNumeroInformado() {
        return this.numeroInformado;
    }

    public void setNumeroInformado(Long numeroInformado) {
        this.numeroInformado = numeroInformado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_CTE_CONJ_TRANSP"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @Column(name="CHAVE_CTE_AUXILIAR", length=36)
    public String getChaveCteAuxiliar() {
        return this.chaveCteAuxiliar;
    }

    public void setChaveCteAuxiliar(String chaveCteAuxiliar) {
        this.chaveCteAuxiliar = chaveCteAuxiliar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VERSAO_CTE", foreignKey=@ForeignKey(name="FK_CTE_VERSAO_CTE"))
    public VersaoCTe getVersaoCte() {
        return this.versaoCte;
    }

    public void setVersaoCte(VersaoCTe versaoCte) {
        this.versaoCte = versaoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_EMISSAO_CTE", foreignKey=@ForeignKey(name="FK_CTE_PER_EMISSAO_CTE"))
    public PeriodoEmissaoCTe getPeriodoEmissaoCte() {
        return this.periodoEmissaoCte;
    }

    public void setPeriodoEmissaoCte(PeriodoEmissaoCTe periodoEmissaoCte) {
        this.periodoEmissaoCte = periodoEmissaoCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_CTE_NATUREZA_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CTeNFe> getCteNfe() {
        return this.cteNfe;
    }

    public void setCteNfe(List<CTeNFe> cteNfe) {
        this.cteNfe = cteNfe;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CTeOutros> getCteOutros() {
        return this.cteOutros;
    }

    public void setCteOutros(List<CTeOutros> cteOutros) {
        this.cteOutros = cteOutros;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public CteInfCarga getCteInfCarga() {
        return this.cteInfCarga;
    }

    public void setCteInfCarga(CteInfCarga cteCarga) {
        this.cteInfCarga = cteCarga;
    }

    @Column(name="TIPO_INF_CTE")
    public Short getTipoInfCte() {
        return this.tipoInfCte;
    }

    public void setTipoInfCte(Short tipoInfCte) {
        this.tipoInfCte = tipoInfCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_CTE_CFOP"))
    public Cfop getCfop() {
        return this.cfop;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_FISCAL", foreignKey=@ForeignKey(name="FK_CTE_UNIDADE_FEDERATIVA"))
    public UnidadeFederativa getUnidadeFedFiscal() {
        return this.unidadeFedFiscal;
    }

    public void setUnidadeFedFiscal(UnidadeFederativa unidadeFedFiscal) {
        this.unidadeFedFiscal = unidadeFedFiscal;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CteSeguro> getCteSeguro() {
        return this.cteSeguro;
    }

    public void setCteSeguro(List<CteSeguro> cteSeguro) {
        this.cteSeguro = cteSeguro;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public CteVlrImpostos getCteVlrImpostos() {
        return this.cteVlrImpostos;
    }

    public void setCteVlrImpostos(CteVlrImpostos cteVlrImpostos) {
        this.cteVlrImpostos = cteVlrImpostos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL_CTE", foreignKey=@ForeignKey(name="FK_CTE_MOD_FISCAL_CTE"))
    public ModeloFiscalCte getModeloFiscalCte() {
        return this.modeloFiscalCte;
    }

    public void setModeloFiscalCte(ModeloFiscalCte modeloFiscalCte) {
        this.modeloFiscalCte = modeloFiscalCte;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_CONTABIL_FAT", foreignKey=@ForeignKey(name="FK_CTE_LOTE_CONT_FATURA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LoteContabil getLoteContabilFat() {
        return this.loteContabilFat;
    }

    public void setLoteContabilFat(LoteContabil loteContabilFat) {
        this.loteContabilFat = loteContabilFat;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_CONTABIL_GER_FAT", foreignKey=@ForeignKey(name="FK_CTE_LOTE_CONT_GER_FATURA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LoteContabil getLoteContabilGerFat() {
        return this.loteContabilGerFat;
    }

    public void setLoteContabilGerFat(LoteContabil loteContabilGerFat) {
        this.loteContabilGerFat = loteContabilGerFat;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CteLacres> getCteLacres() {
        return this.cteLacres;
    }

    public void setCteLacres(List<CteLacres> cteLacres) {
        this.cteLacres = cteLacres;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CteOrdemColeta> getCteOrdemColeta() {
        return this.cteOrdemColeta;
    }

    public void setCteOrdemColeta(List<CteOrdemColeta> cteOrdemColeta) {
        this.cteOrdemColeta = cteOrdemColeta;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CteOnu> getCteOnu() {
        return this.cteOnu;
    }

    public void setCteOnu(List<CteOnu> cteOnu) {
        this.cteOnu = cteOnu;
    }

    @Column(name="OBSERVACAO_GERAL", length=2000)
    public String getObservacaoGeral() {
        return this.observacaoGeral;
    }

    public void setObservacaoGeral(String observacaoGeral) {
        this.observacaoGeral = observacaoGeral;
    }

    @OneToMany(targetEntity=ObservacaoEstNota.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="CTE_OBSERVACOES_int_fisco", joinColumns={@JoinColumn(name="ID_CTE")}, inverseJoinColumns={@JoinColumn(name="ID_OBSERVACAO_ESTNOTA")})
    public List<ObservacaoEstNota> getObservacaoIntFisco() {
        return this.observacaoIntFisco;
    }

    public void setObservacaoIntFisco(List<ObservacaoEstNota> observacaoIntFisco) {
        this.observacaoIntFisco = observacaoIntFisco;
    }

    @OneToMany(targetEntity=RecargaCartaoValePed.class, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="cte_recarga_vl_pedagio", joinColumns={@JoinColumn(name="id_cte")}, inverseJoinColumns={@JoinColumn(name="id_recarga_vale_pedagio")})
    public List<RecargaCartaoValePed> getRecargasValePedagio() {
        return this.recargasValePedagio;
    }

    public void setRecargasValePedagio(List<RecargaCartaoValePed> recargasValePedagio) {
        this.recargasValePedagio = recargasValePedagio;
    }

    @Column(name="VR_TOTAL_NOTAS", precision=12, scale=2)
    public Double getVrTotalNotas() {
        return this.vrTotalNotas;
    }

    public void setVrTotalNotas(Double vrTotalNotas) {
        this.vrTotalNotas = vrTotalNotas;
    }

    @Column(nullable=false, name="QTD_TOTAL_VOLUMES_NFES", precision=15, scale=6)
    public Double getVrTotalVolumesNfes() {
        return this.vrTotalVolumesNfes;
    }

    public void setVrTotalVolumesNfes(Double vrTotalVolumesNfes) {
        this.vrTotalVolumesNfes = vrTotalVolumesNfes;
    }

    @Column(nullable=false, name="PESO_TOTAL_NFES", precision=15, scale=6)
    public Double getPesoTotalNfes() {
        return this.pesoTotalNfes;
    }

    public void setPesoTotalNfes(Double pesoTotalNfes) {
        this.pesoTotalNfes = pesoTotalNfes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE_COMPLEMENTAR", foreignKey=@ForeignKey(name="FK_CTE_CTE_COMPLEMENTAR"))
    public Cte getCteComplementar() {
        return this.cteComplementar;
    }

    public void setCteComplementar(Cte cteComplementar) {
        this.cteComplementar = cteComplementar;
    }

    @Column(name="INF_ADFISCO_CTE_COMP", length=1000)
    public String getInfAdFiscoCteComp() {
        return this.infAdFiscoCteComp;
    }

    public void setInfAdFiscoCteComp(String infAdFiscoCteComp) {
        this.infAdFiscoCteComp = infAdFiscoCteComp;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EmissorDocAntCTe> getEmissorDocAntCTe() {
        return this.emissorDocAntCTe;
    }

    public void setEmissorDocAntCTe(List<EmissorDocAntCTe> emissorDocAntCTe) {
        this.emissorDocAntCTe = emissorDocAntCTe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPER_CTE", foreignKey=@ForeignKey(name="FK_CTE_TIPO_OPERACAO_CTE"))
    public TipoOperacaoCte getTipoOperacaoCte() {
        return this.tipoOperacaoCte;
    }

    public void setTipoOperacaoCte(TipoOperacaoCte tipoOperacaoCte) {
        this.tipoOperacaoCte = tipoOperacaoCte;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public EnderecoColetaCTe getEnderecoColetaCTe() {
        return this.enderecoColetaCTe;
    }

    public void setEnderecoColetaCTe(EnderecoColetaCTe enderecoColetaCTe) {
        this.enderecoColetaCTe = enderecoColetaCTe;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public EnderecoEntregaCTe getEnderecoEntregaCTe() {
        return this.enderecoEntregaCTe;
    }

    public void setEnderecoEntregaCTe(EnderecoEntregaCTe enderecoEntregaCTe) {
        this.enderecoEntregaCTe = enderecoEntregaCTe;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY, optional=true)
    public CteNfPagtoTranspAgregado getCteNfTranspAgregado() {
        return this.cteNfTranspAgregado;
    }

    public void setCteNfTranspAgregado(CteNfPagtoTranspAgregado cteNfTranspAgregado) {
        this.cteNfTranspAgregado = cteNfTranspAgregado;
    }

    @OneToOne(mappedBy="cteGerado", fetch=FetchType.LAZY)
    public ItemClienteTomDiariasCte getItemClienteTomDiariasCte() {
        return this.itemClienteTomDiariasCte;
    }

    public void setItemClienteTomDiariasCte(ItemClienteTomDiariasCte itemClienteTomDiariasCte) {
        this.itemClienteTomDiariasCte = itemClienteTomDiariasCte;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY)
    public BloqueioCTe getBloqueioCte() {
        return this.bloqueioCte;
    }

    public void setBloqueioCte(BloqueioCTe bloqueioCte) {
        this.bloqueioCte = bloqueioCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_CALC_FRETE", foreignKey=@ForeignKey(name="FK_CTE_CALCULO_FRETE"))
    public TabelaCalculoFrete getTabelaCalculoFrete() {
        return this.tabelaCalculoFrete;
    }

    public void setTabelaCalculoFrete(TabelaCalculoFrete tabelaCalculoFrete) {
        this.tabelaCalculoFrete = tabelaCalculoFrete;
    }

    @Column(name="INFORMAR_COMP_MANUAIS")
    public Short getInformarCompManuais() {
        return this.informarCompManuais;
    }

    public void setInformarCompManuais(Short informarCompManuais) {
        this.informarCompManuais = informarCompManuais;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_CTE_REPRESENTANTE"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSP_AGREGADO", foreignKey=@ForeignKey(name="FK_CTE_TRANSPORTADOR_AGREGADO"))
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cte")
    public List<AverbacaoCte> getAverbacaoCte() {
        return this.averbacaoCte;
    }

    public void setAverbacaoCte(List<AverbacaoCte> averbacaoCte) {
        this.averbacaoCte = averbacaoCte;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="cte")
    public ErroAverbacaoCte getErroAverbacaoCte() {
        return this.erroAverbacaoCte;
    }

    public void setErroAverbacaoCte(ErroAverbacaoCte erroAverbacaoCte) {
        this.erroAverbacaoCte = erroAverbacaoCte;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public CancelamentoCte getCancelamentoCTe() {
        return this.cancelamentoCTe;
    }

    public void setCancelamentoCTe(CancelamentoCte cancelamentoCTe) {
        this.cancelamentoCTe = cancelamentoCTe;
    }

    @OneToOne(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public EvtCTeCancelamento getEvtCTeCancelamento() {
        return this.evtCTeCancelamento;
    }

    public void setEvtCTeCancelamento(EvtCTeCancelamento evtCTeCancelamento) {
        this.evtCTeCancelamento = evtCTeCancelamento;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<EvtCTeCartaCorrecao> getEvtCTeCartaCorrecao() {
        return this.evtCTeCartaCorrecao;
    }

    public void setEvtCTeCartaCorrecao(List<EvtCTeCartaCorrecao> evtCTeCartaCorrecao) {
        this.evtCTeCartaCorrecao = evtCTeCartaCorrecao;
    }

    @Column(name="INFORMAR_CARGA_MANUAIS")
    public Short getInformarCargaManuais() {
        return this.informarCargaManuais;
    }

    public void setInformarCargaManuais(Short informarCargaManuais) {
        this.informarCargaManuais = informarCargaManuais;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREV_VIAGEM")
    public Date getDataPrevViagem() {
        return this.dataPrevViagem;
    }

    public void setDataPrevViagem(Date dataPrevViagem) {
        this.dataPrevViagem = dataPrevViagem;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CTeAutDownloadXML> getCteDownloadXML() {
        return this.cteDownloadXML;
    }

    public void setCteDownloadXML(List<CTeAutDownloadXML> cteDownloadXML) {
        this.cteDownloadXML = cteDownloadXML;
    }

    @Column(name="BLOQUEAR_FATURA")
    public Short getBloquearFatura() {
        return this.bloquearFatura;
    }

    public void setBloquearFatura(Short bloquearFatura) {
        this.bloquearFatura = bloquearFatura;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE_ANULACAO", foreignKey=@ForeignKey(name="FK_CTE_CTE_ANULACAO"))
    public Cte getCteAnulacao() {
        return this.cteAnulacao;
    }

    public void setCteAnulacao(Cte cteAnulacao) {
        this.cteAnulacao = cteAnulacao;
    }

    @Column(name="DATA_DECLARACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataDeclaracao() {
        return this.dataDeclaracao;
    }

    public void setDataDeclaracao(Date dataDeclaracao) {
        this.dataDeclaracao = dataDeclaracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE_SUBSTITUICAO_ORIGINAL", foreignKey=@ForeignKey(name="FK_CTE_CTE_SUBSTIT_ORIGINAL"))
    public Cte getCteSubstituicaoOriginal() {
        return this.cteSubstituicaoOriginal;
    }

    public void setCteSubstituicaoOriginal(Cte cteSubstituicaoOriginal) {
        this.cteSubstituicaoOriginal = cteSubstituicaoOriginal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE_SUBSTITUICAO_ANULACAO", foreignKey=@ForeignKey(name="FK_CTE_CTE_SUBSTIT_ANULACAO"))
    public Cte getCteSubstituicaoAnulacao() {
        return this.cteSubstituicaoAnulacao;
    }

    public void setCteSubstituicaoAnulacao(Cte cteSubstituicaoAnulacao) {
        this.cteSubstituicaoAnulacao = cteSubstituicaoAnulacao;
    }

    @Column(name="CHAVE_SUBSTITUICAO_NFE", length=44)
    public String getChaveSubstituicaoNfe() {
        return this.chaveSubstituicaoNfe;
    }

    public void setChaveSubstituicaoNfe(String chaveSubstituicaoNfe) {
        this.chaveSubstituicaoNfe = chaveSubstituicaoNfe;
    }

    @Column(name="CHAVE_SUBSTITUICAO_CTE", length=44)
    public String getChaveSubstituicaoCte() {
        return this.chaveSubstituicaoCte;
    }

    public void setChaveSubstituicaoCte(String chaveSubstituicaoCte) {
        this.chaveSubstituicaoCte = chaveSubstituicaoCte;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @Column(name="GERAR_AVERBACAO")
    public Short getGerarAverbacao() {
        return this.gerarAverbacao;
    }

    public void setGerarAverbacao(Short gerarAverbacao) {
        this.gerarAverbacao = gerarAverbacao;
    }

    @Column(name="STATUS_STRATUM")
    public Short getStatusStratum() {
        return this.statusStratum;
    }

    public void setStatusStratum(Short statusStratum) {
        this.statusStratum = statusStratum;
    }

    @Column(name="ENVIAR_CTE_STRATUM")
    public Short getEnviarCteStratum() {
        return this.enviarCteStratum;
    }

    public void setEnviarCteStratum(Short enviarCteStratum) {
        this.enviarCteStratum = enviarCteStratum;
    }

    @Column(name="CHAVE_CTE_INF", length=44)
    public String getChaveCteInf() {
        return this.chaveCteInf;
    }

    public void setChaveCteInf(String chaveCteInf) {
        this.chaveCteInf = chaveCteInf;
    }

    @Ignore
    @Column(name="DIGITO_VERIFICADOR_INF")
    public Integer getDigitoVerificadorInf() {
        return this.digitoVerificadorInf;
    }

    public void setDigitoVerificadorInf(Integer digitoVerificadorInf) {
        this.digitoVerificadorInf = digitoVerificadorInf;
    }

    @Column(name="PROTOCOLO_RASTREAMENTO", length=5000)
    public String getProtocoloRastreamento() {
        return this.protocoloRastreamento;
    }

    public void setProtocoloRastreamento(String protocoloRastreamento) {
        this.protocoloRastreamento = protocoloRastreamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CRIACAO", foreignKey=@ForeignKey(name="FK_CTE_USUARIO_CRIACAO"))
    public Usuario getUsuarioCriacao() {
        return this.usuarioCriacao;
    }

    public void setUsuarioCriacao(Usuario usuarioCriacao) {
        this.usuarioCriacao = usuarioCriacao;
    }

    @Column(name="DATA_CRIACAO")
    public Timestamp getDataCriacao() {
        return this.dataCriacao;
    }

    public void setDataCriacao(Timestamp dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_INICIO", foreignKey=@ForeignKey(name="FK_CTE_CIDADE_INICIO"))
    public Cidade getCidadeInicio() {
        return this.cidadeInicio;
    }

    public void setCidadeInicio(Cidade cidadeInicio) {
        this.cidadeInicio = cidadeInicio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_FIM", foreignKey=@ForeignKey(name="FK_CTE_CIDADE_FIM"))
    public Cidade getCidadeFim() {
        return this.cidadeFim;
    }

    public void setCidadeFim(Cidade cidadeFim) {
        this.cidadeFim = cidadeFim;
    }

    @Column(name="GERAR_MANIFESTO_AUT")
    public Short getGerarManifestoAut() {
        return this.gerarManifestoAut;
    }

    public void setGerarManifestoAut(Short gerarManifestoAut) {
        this.gerarManifestoAut = gerarManifestoAut;
    }

    @ManyToOne(targetEntity=ProgramacaoViagens.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROGRAMACAO_VIAGENS", foreignKey=@ForeignKey(name="FK_CTE_PROGRAMACAO_VIAGENS"))
    public ProgramacaoViagens getProgramacaoViagens() {
        return this.programacaoViagens;
    }

    public void setProgramacaoViagens(ProgramacaoViagens programacaoViagens) {
        this.programacaoViagens = programacaoViagens;
    }

    @Column(name="CHAVE_COMPLEMENTAR", length=44)
    public String getChaveComplementar() {
        return this.chaveComplementar;
    }

    public void setChaveComplementar(String chaveComplementar) {
        this.chaveComplementar = chaveComplementar;
    }

    @Column(name="CHAVE_CTE_ANULACAO", length=44)
    public String getChaveCteAnulacao() {
        return this.chaveCteAnulacao;
    }

    public void setChaveCteAnulacao(String chaveCteAnulacao) {
        this.chaveCteAnulacao = chaveCteAnulacao;
    }

    @Column(name="CHAVE_CTE_SUBSTITUICAO", length=44)
    public String getChaveCteSubstituicao() {
        return this.chaveCteSubstituicao;
    }

    public void setChaveCteSubstituicao(String chaveCteSubstituicao) {
        this.chaveCteSubstituicao = chaveCteSubstituicao;
    }

    @Column(name="NUMERO_AVERBACAO", length=100)
    public String getNumeroAverbacao() {
        return this.numeroAverbacao;
    }

    public void setNumeroAverbacao(String numeroAverbacao) {
        this.numeroAverbacao = numeroAverbacao;
    }

    @Column(name="APROVADO_AVERBACAO")
    public Short getAprovadoAverbacao() {
        return this.aprovadoAverbacao;
    }

    public void setAprovadoAverbacao(Short aprovadoAverbacao) {
        this.aprovadoAverbacao = aprovadoAverbacao;
    }

    @Column(name="CANCELADO_AVERBACAO")
    public Short getCanceladoAverbacao() {
        return this.canceladoAverbacao;
    }

    public void setCanceladoAverbacao(Short canceladoAverbacao) {
        this.canceladoAverbacao = canceladoAverbacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MODAL", foreignKey=@ForeignKey(name="FK_CTE_TIPO_MODAL"))
    public TipoModal getModalCte() {
        return this.modalCte;
    }

    public void setModalCte(TipoModal modalCte) {
        this.modalCte = modalCte;
    }

    @OneToOne(mappedBy="cte", cascade={CascadeType.ALL}, orphanRemoval=true)
    public CteAquaviario getCteAquaviario() {
        return this.cteAquaviario;
    }

    public void setCteAquaviario(CteAquaviario cteAquaviario) {
        this.cteAquaviario = cteAquaviario;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CTeVeiculosTransportados> getCteVeiculosTransportados() {
        return this.cteVeiculosTransportados;
    }

    public void setCteVeiculosTransportados(List<CTeVeiculosTransportados> cteVeiculosTransportados) {
        this.cteVeiculosTransportados = cteVeiculosTransportados;
    }

    @OneToMany(mappedBy="cte", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CTeServVincMultimodal> getCteServVincMultimodal() {
        return this.cteServVincMultimodal;
    }

    public void setCteServVincMultimodal(List<CTeServVincMultimodal> cteServVincMultimodal) {
        this.cteServVincMultimodal = cteServVincMultimodal;
    }

    @Column(name="IND_CTE_GLOBALIZADO")
    public Short getIndCteGlobalizado() {
        return this.indCteGlobalizado;
    }

    public void setIndCteGlobalizado(Short indCteGlobalizado) {
        this.indCteGlobalizado = indCteGlobalizado;
    }

    @Column(name="INF_DADOS_REFORMA_TRIBUTARIA")
    public Short getInformarDadosReformaTributaria() {
        return this.informarDadosReformaTributaria;
    }

    public void setInformarDadosReformaTributaria(Short informarDadosReformaTributaria) {
        this.informarDadosReformaTributaria = informarDadosReformaTributaria;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_PARAM_TRIB_CBS_IBS_CLASS")
    public ParamTribCbsIbsClass getParamTribCbsIbsClass() {
        return this.paramTribCbsIbsClass;
    }

    public void setParamTribCbsIbsClass(ParamTribCbsIbsClass paramTribCbsIbsClass) {
        this.paramTribCbsIbsClass = paramTribCbsIbsClass;
    }
}

