/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="DOC_FISCAL_BEM")
public class DocFiscalBem
implements InterfaceVO {
    private Long identificador;
    private String serie;
    private Integer numeroNota = 0;
    private Date dataEmissao;
    private String chaveNFe;
    private ModeloDocFiscal modeloDocFiscal;
    private Short indicadorEmitente = 0;
    private Pessoa pessoa;
    private List<Produto> produtos = new ArrayList<Produto>();
    private Bem bem;

    @Id
    @Column(name="ID_DOC_FISCAL_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DOC_FISCAL_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="NUMERO_NOTA")
    public Integer getNumeroNota() {
        return this.numeroNota;
    }

    public void setNumeroNota(Integer numeroNota) {
        this.numeroNota = numeroNota;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="CHAVE_NFE", length=44)
    public String getChaveNFe() {
        return this.chaveNFe;
    }

    public void setChaveNFe(String chaveNFe) {
        this.chaveNFe = chaveNFe;
    }

    @JoinColumn(nullable=false, name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_DOC_FISCAL_BEM_MOD_DOC_FISCA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Column(name="INDICADOR_EMITENTE")
    public Short getIndicadorEmitente() {
        return this.indicadorEmitente;
    }

    public void setIndicadorEmitente(Short indicadorEmitente) {
        this.indicadorEmitente = indicadorEmitente;
    }

    @JoinColumn(nullable=false, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_DOC_FISCAL_BEM_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @OneToMany
    @JoinTable(name="doc_fiscal_bem_produto", joinColumns={@JoinColumn(name="id_doc_fiscal_bem")}, inverseJoinColumns={@JoinColumn(name="id_produto")})
    public List<Produto> getProdutos() {
        return this.produtos;
    }

    public void setProdutos(List<Produto> produtos) {
        this.produtos = produtos;
    }

    @JoinColumn(name="ID_BEM", foreignKey=@ForeignKey(name="FK_DOC_FISCAL_BEM_BEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Bem getBem() {
        return this.bem;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - Numero Nota: {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumeroNota()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

