/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.EmbalagemProducaoOS;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.ItemEmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EMBALAGEM_EXPEDICAO")
public class EmbalagemExpedicao
implements InterfaceVO {
    private Long identificador;
    private Short lacraEmbalagem = 0;
    private Double pesoBruto = 0.0;
    private Double pesoLiquido = 0.0;
    private Double volume = 0.0;
    private Short opcaoCaixa = 0;
    private Double volumeUtilizado = 0.0;
    private Usuario usuario;
    private Date dataConferencia;
    private List<ItemEmbalagemExpedicao> itemEmbalagemExpedicao = new ArrayList<ItemEmbalagemExpedicao>();
    private Embalagem embalagem;
    private Expedicao expedicao;
    private Integer nrEmbalagem = 0;
    private EmbalagemProducaoOS embalagemProdOS;
    private EmbalagemProducao embalagemProducao;
    private String justificativa;

    @Id
    @Column(nullable=false, unique=true, name="ID_EMBALAGEM_EXPEDICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMBALAGEM_EXPEDICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="LACRA_EMBALAGEM")
    public Short getLacraEmbalagem() {
        return this.lacraEmbalagem;
    }

    public void setLacraEmbalagem(Short lacraEmbalagem) {
        this.lacraEmbalagem = lacraEmbalagem;
    }

    @Column(name="PESO_BRUTO", precision=12, scale=2)
    public Double getPesoBruto() {
        return this.pesoBruto;
    }

    public void setPesoBruto(Double pesoBruto) {
        this.pesoBruto = pesoBruto;
    }

    @Column(name="PESO_LIQUIDO", precision=12, scale=2)
    public Double getPesoLiquido() {
        return this.pesoLiquido;
    }

    public void setPesoLiquido(Double pesoLiquido) {
        this.pesoLiquido = pesoLiquido;
    }

    @Column(nullable=false, name="VOLUME", precision=12, scale=2)
    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @Column(nullable=false, name="VOLUME_UTILIZADO", precision=12, scale=2)
    public Double getVolumeUtilizado() {
        return this.volumeUtilizado;
    }

    public void setVolumeUtilizado(Double volumeUtilizado) {
        this.volumeUtilizado = volumeUtilizado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EXPEDICAO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="DATA_CONFERENCIA")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataConferencia() {
        return this.dataConferencia;
    }

    public void setDataConferencia(Date dataConferencia) {
        this.dataConferencia = dataConferencia;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="embalagemExpedicao", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemEmbalagemExpedicao> getItemEmbalagemExpedicao() {
        return this.itemEmbalagemExpedicao;
    }

    public void setItemEmbalagemExpedicao(List itemEmbalagemExpedicao) {
        this.itemEmbalagemExpedicao = itemEmbalagemExpedicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EXPEDICAO_EMBALAGE"))
    public Embalagem getEmbalagem() {
        return this.embalagem;
    }

    public void setEmbalagem(Embalagem embalagem) {
        this.embalagem = embalagem;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getEmbalagem()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EXPEDICAO", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EXPEDICAO_EXPEDICA"))
    public Expedicao getExpedicao() {
        return this.expedicao;
    }

    public void setExpedicao(Expedicao expedicao) {
        this.expedicao = expedicao;
    }

    @Column(name="OPCAO_CAIXA")
    public Short getOpcaoCaixa() {
        return this.opcaoCaixa;
    }

    public void setOpcaoCaixa(Short opcaoCaixa) {
        this.opcaoCaixa = opcaoCaixa;
    }

    @Column(name="NR_EMBALAGEM")
    public Integer getNrEmbalagem() {
        return this.nrEmbalagem;
    }

    public void setNrEmbalagem(Integer nrEmbalagem) {
        this.nrEmbalagem = nrEmbalagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM_PROD_OS", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EXPEDICAO_EMB_PR_O"))
    public EmbalagemProducaoOS getEmbalagemProdOS() {
        return this.embalagemProdOS;
    }

    public void setEmbalagemProdOS(EmbalagemProducaoOS embalagemProdOS) {
        this.embalagemProdOS = embalagemProdOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM_PROD", foreignKey=@ForeignKey(name="FK_EMBALAGEM_EXPEDICAO_EMB_PR"))
    public EmbalagemProducao getEmbalagemProducao() {
        return this.embalagemProducao;
    }

    public void setEmbalagemProducao(EmbalagemProducao embalagemProducao) {
        this.embalagemProducao = embalagemProducao;
    }

    @Column(name="JUSTIFICATIVA", length=500)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }
}

