/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.embarcacao.EnumConstCategoriaEmbarcacao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="EMBARCACAO")
public class Embarcacao
implements InterfaceVO {
    @Id
    @Column(name="ID_EMBARCACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMBARCACAO")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    private Date dataCadastro;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMBARCACAO_EMPRESA"))
    private Empresa empresa;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Date dataAtualizacao;
    @Column(name="CLASSIFICACAO_EMBARCACAO")
    private Short classificacaoEmbarcacao;
    @Column(name="TIPO_EMBARCACAO")
    private Integer tipoEmbarcacao;
    @Column(name="CODIGO", length=10)
    private String codigo;
    @Column(name="DESCRICAO", length=60)
    private String descricao;
    @Column(name="IDENTIFICACAO_EMBARCACAO", length=10)
    private String identificacaoEmbarcacao;

    public Embarcacao() {
        this.classificacaoEmbarcacao = EnumConstCategoriaEmbarcacao.CATEGORIA_NAVIO.value;
        this.tipoEmbarcacao = 0;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Short getClassificacaoEmbarcacao() {
        return this.classificacaoEmbarcacao;
    }

    @Generated
    public Integer getTipoEmbarcacao() {
        return this.tipoEmbarcacao;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getIdentificacaoEmbarcacao() {
        return this.identificacaoEmbarcacao;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setClassificacaoEmbarcacao(Short classificacaoEmbarcacao) {
        this.classificacaoEmbarcacao = classificacaoEmbarcacao;
    }

    @Generated
    public void setTipoEmbarcacao(Integer tipoEmbarcacao) {
        this.tipoEmbarcacao = tipoEmbarcacao;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setIdentificacaoEmbarcacao(String identificacaoEmbarcacao) {
        this.identificacaoEmbarcacao = identificacaoEmbarcacao;
    }
}

