/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.ClassificacaoIndustria;
import com.touchcomp.basementor.model.vo.FusoHorario;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IndicadorAtividade;
import com.touchcomp.basementor.model.vo.IndicadorNaturezaPessoaJuridica;
import com.touchcomp.basementor.model.vo.PerfilSpedFiscal;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Proxy;
import com.touchcomp.basementor.model.vo.RegimeTributario;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TipoEmpresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="EMPRESA_DADOS")
public class EmpresaDados
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String inscJuntaComercial;
    private String inscBancoCentral;
    private String inscSusep;
    private String inscCVM;
    private String inscANTT;
    private byte[] logoRelatorios;
    private byte[] logoBoleto;
    private Timestamp dataAtualizacao;
    private TipoEmpresa tipoEmpresa;
    private PerfilSpedFiscal perfilSpedFiscal;
    private RegimeTributario regimeTributario;
    private Short indicadorApuracaoIpi = 0;
    private Short lancarCtoCustoEntrada = 0;
    private Double aliquotaICMSSimples = 0.0;
    private IndicadorAtividade indicadorAtividade;
    private GrupoEmpresa grupoEmpresa;
    private Short matriz = 0;
    private Short incentivadorCultural = 0;
    private Short ativo = 1;
    private Proxy proxyHTTP;
    private Proxy proxyEmail;
    private CNAE cnae;
    private Short permitirAlterarNCM = 0;
    private Short tipoFusoHorario = 0;
    private FusoHorario fusoHorario;
    private CentroResultadoContFin centroResultadoContFin;
    private Pessoa fornecedorFolhaPagamento;
    private Short bloquearProdutoSemNcm = 0;
    private Short excluirBIInativar = 1;
    private IndicadorNaturezaPessoaJuridica indicadorNaturezaJuridica;
    private Short utilizarTabPrecoEntProdutos = 0;
    private TabelaPrecoBase tabelaPrecoBase;
    private String keyAPIGoogle;
    private String corBackground;
    private String corForeground;
    private Short filtrarProdutosModeloFiscal = 0;
    private ClassificacaoIndustria classificacaoIndustria;
    private String codigoEmpresa;

    @Id
    @Column(nullable=false, unique=true, name="ID_EMPRESA_DADOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EMPRESA_DADOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERFIL_SPED_FISCAL", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_PERF_SPED_F"))
    public PerfilSpedFiscal getPerfilSpedFiscal() {
        return this.perfilSpedFiscal;
    }

    public void setPerfilSpedFiscal(PerfilSpedFiscal perfilSpedFiscal) {
        this.perfilSpedFiscal = perfilSpedFiscal;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dtCad) {
        this.dataCadastro = dtCad;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INSC_JUNTA_COMERCIAL", length=25)
    public String getInscJuntaComercial() {
        return this.inscJuntaComercial;
    }

    public void setInscJuntaComercial(String inscJuntaComercial) {
        this.inscJuntaComercial = inscJuntaComercial;
    }

    @Column(name="INSC_BANCO_CENTRAL", length=25)
    public String getInscBancoCentral() {
        return this.inscBancoCentral;
    }

    public void setInscBancoCentral(String inscBancoCentral) {
        this.inscBancoCentral = inscBancoCentral;
    }

    @Column(name="INSC_SUSEP", length=25)
    public String getInscSusep() {
        return this.inscSusep;
    }

    public void setInscSusep(String inscSusep) {
        this.inscSusep = inscSusep;
    }

    @Column(name="INSC_CVM", length=25)
    public String getInscCVM() {
        return this.inscCVM;
    }

    public void setInscCVM(String inscCVM) {
        this.inscCVM = inscCVM;
    }

    @Column(name="INSC_ANTT", length=8)
    public String getInscANTT() {
        return this.inscANTT;
    }

    public void setInscANTT(String inscANTT) {
        this.inscANTT = inscANTT;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_TP_EMPRESA"))
    public TipoEmpresa getTipoEmpresa() {
        return this.tipoEmpresa;
    }

    public void setTipoEmpresa(TipoEmpresa tipoEmpresa) {
        this.tipoEmpresa = tipoEmpresa;
    }

    @Column(name="LOGO_RELATORIOS")
    public byte[] getLogoRelatorios() {
        return this.logoRelatorios;
    }

    public void setLogoRelatorios(byte[] logoRelatorios) {
        this.logoRelatorios = logoRelatorios;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_TRIBUTARIO", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_REG_TRIB"))
    public RegimeTributario getRegimeTributario() {
        return this.regimeTributario;
    }

    public void setRegimeTributario(RegimeTributario regimeTributario) {
        this.regimeTributario = regimeTributario;
    }

    @Column(name="INDICADOR_APURACAO_IPI")
    public Short getIndicadorApuracaoIpi() {
        return this.indicadorApuracaoIpi;
    }

    public void setIndicadorApuracaoIpi(Short indicadorApuracaoIpi) {
        this.indicadorApuracaoIpi = indicadorApuracaoIpi;
    }

    @Column(name="LANCAR_CTO_CUSTO_ENTRADA")
    public Short getLancarCtoCustoEntrada() {
        return this.lancarCtoCustoEntrada;
    }

    public void setLancarCtoCustoEntrada(Short lancarCtoEntrada) {
        this.lancarCtoCustoEntrada = lancarCtoEntrada;
    }

    @Column(nullable=false, name="ALIQUOTA_ICMS_SIMPLES", precision=15, scale=2)
    public Double getAliquotaICMSSimples() {
        return this.aliquotaICMSSimples;
    }

    public void setAliquotaICMSSimples(Double aliquotaICMSSimples) {
        this.aliquotaICMSSimples = aliquotaICMSSimples;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICADOR_ATIVIDADE", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_IND_ATIVIDADE"))
    public IndicadorAtividade getIndicadorAtividade() {
        return this.indicadorAtividade;
    }

    public void setIndicadorAtividade(IndicadorAtividade indicadorAtividade) {
        this.indicadorAtividade = indicadorAtividade;
    }

    @Column(name="LOGO_BOLETO")
    public byte[] getLogoBoleto() {
        return this.logoBoleto;
    }

    public void setLogoBoleto(byte[] logoBoleto) {
        this.logoBoleto = logoBoleto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_GR_EMPRESA"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Column(name="MATRIZ")
    public Short getMatriz() {
        return this.matriz;
    }

    public void setMatriz(Short matriz) {
        this.matriz = matriz;
    }

    @Column(name="INCENTIVADOR_CULTURAL")
    public Short getIncentivadorCultural() {
        return this.incentivadorCultural;
    }

    public void setIncentivadorCultural(Short incentivadorCultural) {
        this.incentivadorCultural = incentivadorCultural;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROXY_HTTP", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_PROXY_HTTP"))
    public Proxy getProxyHTTP() {
        return this.proxyHTTP;
    }

    public void setProxyHTTP(Proxy proxyHTTP) {
        this.proxyHTTP = proxyHTTP;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROXY_EMAIL", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_PROXY_EMAIL"))
    public Proxy getProxyEmail() {
        return this.proxyEmail;
    }

    public void setProxyEmail(Proxy proxyEmail) {
        this.proxyEmail = proxyEmail;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_CNAE"))
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @Column(name="PERMITIR_ALTERAR_NCM")
    public Short getPermitirAlterarNCM() {
        return this.permitirAlterarNCM;
    }

    public void setPermitirAlterarNCM(Short permitirAlterarNCM) {
        this.permitirAlterarNCM = permitirAlterarNCM;
    }

    @Column(name="TIPO_FUSO_HORARIO")
    public Short getTipoFusoHorario() {
        return this.tipoFusoHorario;
    }

    public void setTipoFusoHorario(Short tipoFusoHorario) {
        this.tipoFusoHorario = tipoFusoHorario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUSO_HORARIO", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_FUSO_HORARIO"))
    public FusoHorario getFusoHorario() {
        return this.fusoHorario;
    }

    public void setFusoHorario(FusoHorario fusoHorario) {
        this.fusoHorario = fusoHorario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_RESULTADO_CONT_FIN", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_CENT_RES_CON_F"))
    public CentroResultadoContFin getCentroResultadoContFin() {
        return this.centroResultadoContFin;
    }

    public void setCentroResultadoContFin(CentroResultadoContFin centroResultadoContFin) {
        this.centroResultadoContFin = centroResultadoContFin;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR_FOLHA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_FORNC_FOLHA"))
    public Pessoa getFornecedorFolhaPagamento() {
        return this.fornecedorFolhaPagamento;
    }

    public void setFornecedorFolhaPagamento(Pessoa fornecedorFolhaPagamento) {
        this.fornecedorFolhaPagamento = fornecedorFolhaPagamento;
    }

    @Column(name="BLOQUEAR_PROD_SEM_NCM")
    public Short getBloquearProdutoSemNcm() {
        return this.bloquearProdutoSemNcm;
    }

    public void setBloquearProdutoSemNcm(Short bloquearProdutoSemNcm) {
        this.bloquearProdutoSemNcm = bloquearProdutoSemNcm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICADOR_NATUREZA_JURIDICA", foreignKey=@ForeignKey(name="FK_EMPRESA_IND_NATUREZA_JURIDIC"))
    public IndicadorNaturezaPessoaJuridica getIndicadorNaturezaJuridica() {
        return this.indicadorNaturezaJuridica;
    }

    public void setIndicadorNaturezaJuridica(IndicadorNaturezaPessoaJuridica indicadorNaturezaJuridica) {
        this.indicadorNaturezaJuridica = indicadorNaturezaJuridica;
    }

    @Column(nullable=false, name="EXCLUIR_BI_INATIVAR")
    public Short getExcluirBIInativar() {
        return this.excluirBIInativar;
    }

    public void setExcluirBIInativar(Short excluirBIInativar) {
        this.excluirBIInativar = excluirBIInativar;
    }

    @Column(name="UTILIZAR_TAB_PR_ENTR_PROD_EST")
    public Short getUtilizarTabPrecoEntProdutos() {
        return this.utilizarTabPrecoEntProdutos;
    }

    public void setUtilizarTabPrecoEntProdutos(Short utilizarTabPrecoEntProdutos) {
        this.utilizarTabPrecoEntProdutos = utilizarTabPrecoEntProdutos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_PRECOS_BASE", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_TAB_BASE"))
    public TabelaPrecoBase getTabelaPrecoBase() {
        return this.tabelaPrecoBase;
    }

    public void setTabelaPrecoBase(TabelaPrecoBase tabelaPrecoBase) {
        this.tabelaPrecoBase = tabelaPrecoBase;
    }

    @Column(name="KEY_API_GOOGLE", length=100)
    public String getKeyAPIGoogle() {
        return this.keyAPIGoogle;
    }

    public void setKeyAPIGoogle(String keyAPIGoogle) {
        this.keyAPIGoogle = keyAPIGoogle;
    }

    @Column(name="COR_BACKGROUND", length=10)
    public String getCorBackground() {
        return this.corBackground;
    }

    public void setCorBackground(String corBackground) {
        this.corBackground = corBackground;
    }

    @Column(name="COR_FOREGROUND", length=10)
    public String getCorForeground() {
        return this.corForeground;
    }

    public void setCorForeground(String corForeground) {
        this.corForeground = corForeground;
    }

    @Column(name="FILTRAR_PROD_MODELO_FISCAL")
    public Short getFiltrarProdutosModeloFiscal() {
        return this.filtrarProdutosModeloFiscal;
    }

    public void setFiltrarProdutosModeloFiscal(Short filtrarProdutosModeloFiscal) {
        this.filtrarProdutosModeloFiscal = filtrarProdutosModeloFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_INDUSTRIA", foreignKey=@ForeignKey(name="FK_EMPRESA_DADOS_CLASS_INDUSTR"))
    public ClassificacaoIndustria getClassificacaoIndustria() {
        return this.classificacaoIndustria;
    }

    public void setClassificacaoIndustria(ClassificacaoIndustria classificacaoIndustria) {
        this.classificacaoIndustria = classificacaoIndustria;
    }

    @Column(name="codigo_empresa")
    public String getCodigoEmpresa() {
        return this.codigoEmpresa;
    }

    public void setCodigoEmpresa(String codigoEmpresa) {
        this.codigoEmpresa = codigoEmpresa;
    }
}

