/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EquipamentoProduto;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.MedidaConsumoAtivo;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RelacaoEquipamento;
import com.touchcomp.basementor.model.vo.TipoEquipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControleAtivo;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EQUIPAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_EQUIPAMENTO_CODIGO", columnNames={"CODIGO"})})
public class Equipamento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short ativo = 1;
    private Double quantidadeConsumo = 0.0;
    private String nome;
    private String codigo;
    private String numeroChassis;
    private String modelo;
    private String especificao;
    private Date dataCompra;
    private Date dataVenda;
    private Pessoa empresaProprietaria;
    private Fornecedor fornecedor;
    private Fabricante fabricante;
    private Veiculo veiculo;
    private CentroCusto centroCusto;
    private PlanoConta contaContabil;
    private PlanoContaGerencial contaGerencial;
    private TipoEquipamento tipoEquipamento;
    private LocalizacaoAtivo localizacaoAtivo;
    private MedidaConsumoAtivo medidaConsumoAtivo;
    private List<EquipamentoProduto> combustiveis = new ArrayList<EquipamentoProduto>();
    private List<TipoPontoControleAtivo> tipoPontoControleAtivo = new ArrayList<TipoPontoControleAtivo>();
    private List<RelacaoEquipamento> ativos = new ArrayList<RelacaoEquipamento>();
    private Bem bem;
    private String observacao;
    private NotaFiscalPropria notaPropria;
    private NotaFiscalTerceiros notaTerceiros;

    @OneToMany(mappedBy="equipamento", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EquipamentoProduto> getCombustiveis() {
        return this.combustiveis;
    }

    public void setCombustiveis(List<EquipamentoProduto> combustiveis) {
        this.combustiveis = combustiveis;
    }

    @Id
    @Column(nullable=false, name="ID_EQUIPAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EQUIPAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="CODIGO", length=20)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_TIPO_EQUIPAMENTO"))
    public TipoEquipamento getTipoEquipamento() {
        return this.tipoEquipamento;
    }

    public void setTipoEquipamento(TipoEquipamento tipoEquipamento) {
        this.tipoEquipamento = tipoEquipamento;
    }

    @Column(nullable=false, name="NOME", length=80)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="NUMERO_CHASSIS", length=50)
    public String getNumeroChassis() {
        return this.numeroChassis;
    }

    public void setNumeroChassis(String numeroChassis) {
        this.numeroChassis = numeroChassis;
    }

    @Column(name="MODELO", length=50)
    public String getModelo() {
        return this.modelo;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
    }

    @OneToOne(mappedBy="equipamento")
    public Veiculo getVeiculo() {
        return this.veiculo;
    }

    public void setVeiculo(Veiculo veiculo) {
        this.veiculo = veiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_CEN_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @OneToMany(mappedBy="equipamento", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoPontoControleAtivo> getTipoPontoControleAtivo() {
        return this.tipoPontoControleAtivo;
    }

    public void setTipoPontoControleAtivo(List<TipoPontoControleAtivo> tipoPontoControleAtivo) {
        this.tipoPontoControleAtivo = tipoPontoControleAtivo;
    }

    @OneToMany(mappedBy="equipamentoPai", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RelacaoEquipamento> getAtivos() {
        return this.ativos;
    }

    public void setAtivos(List<RelacaoEquipamento> ativos) {
        this.ativos = ativos;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="QUANTIDADE_CONSUMO", precision=15, scale=6)
    public Double getQuantidadeConsumo() {
        return this.quantidadeConsumo;
    }

    public void setQuantidadeConsumo(Double quantidadeConsumo) {
        this.quantidadeConsumo = quantidadeConsumo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA_PROP", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_EMP_PROP"))
    public Pessoa getEmpresaProprietaria() {
        return this.empresaProprietaria;
    }

    public void setEmpresaProprietaria(Pessoa empresaProprietaria) {
        this.empresaProprietaria = empresaProprietaria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_CONTABIL", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_CONT_CONTABIL"))
    public PlanoConta getContaContabil() {
        return this.contaContabil;
    }

    public void setContaContabil(PlanoConta contaContabil) {
        this.contaContabil = contaContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_PC_GER"))
    public PlanoContaGerencial getContaGerencial() {
        return this.contaGerencial;
    }

    public void setContaGerencial(PlanoContaGerencial contaGerencial) {
        this.contaGerencial = contaGerencial;
    }

    @Column(name="ESPECIFICAO", length=250)
    public String getEspecificao() {
        return this.especificao;
    }

    public void setEspecificao(String especificao) {
        this.especificao = especificao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_FORNECEDOR"))
    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FABRICANTE", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_FABRICANTE"))
    public Fabricante getFabricante() {
        return this.fabricante;
    }

    public void setFabricante(Fabricante fabricante) {
        this.fabricante = fabricante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCALIZACAO_ATIVO", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_LOC_ATIVO"))
    public LocalizacaoAtivo getLocalizacaoAtivo() {
        return this.localizacaoAtivo;
    }

    public void setLocalizacaoAtivo(LocalizacaoAtivo localizacaoAtivo) {
        this.localizacaoAtivo = localizacaoAtivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEDIDA_CONSUMO_ATIVO", foreignKey=@ForeignKey(name="FK_EQUIPAMENTO_MED_CONS_ATIVO"))
    public MedidaConsumoAtivo getMedidaConsumoAtivo() {
        return this.medidaConsumoAtivo;
    }

    public void setMedidaConsumoAtivo(MedidaConsumoAtivo medidaConsumoAtivo) {
        this.medidaConsumoAtivo = medidaConsumoAtivo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPRA")
    public Date getDataCompra() {
        return this.dataCompra;
    }

    public void setDataCompra(Date dataCompra) {
        this.dataCompra = dataCompra;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENDA")
    public Date getDataVenda() {
        return this.dataVenda;
    }

    public void setDataVenda(Date dataVenda) {
        this.dataVenda = dataVenda;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getVeiculo() != null) {
            return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getVeiculo().getPlaca(), this.getNome()});
        }
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="equipamento")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Bem getBem() {
        return this.bem;
    }

    public void setBem(Bem bem) {
        this.bem = bem;
    }

    @Column(name="observacao", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_NOTA_PROPRIA"))
    public NotaFiscalPropria getNotaPropria() {
        return this.notaPropria;
    }

    public void setNotaPropria(NotaFiscalPropria notaPropria) {
        this.notaPropria = notaPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_NOTA_TERCEIROS"))
    public NotaFiscalTerceiros getNotaTerceiros() {
        return this.notaTerceiros;
    }

    public void setNotaTerceiros(NotaFiscalTerceiros notaTerceiros) {
        this.notaTerceiros = notaTerceiros;
    }
}

