/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.EsocAquisicaoProducaoRural;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.NotaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.ReinfAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ESOC_FORNECEDOR_PRODUCAO_RURAL")
public class EsocFornecedorProducaoRural
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private EsocAquisicaoProducaoRural esocAquisicao;
    private Fornecedor fornecedor;
    private Double valorBrutoAquisicao;
    private List<NotaAquisicaoProdRural> notasAqProdRural;
    private ReinfAquisicaoProdRural reinfAquisicao;
    private List<ReinfPreEvento> preEventosReinf;

    public EsocFornecedorProducaoRural() {
        this.valorBrutoAquisicao = 0.0;
        this.notasAqProdRural = new ArrayList<NotaAquisicaoProdRural>();
        this.preEventosReinf = new ArrayList<ReinfPreEvento>();
    }

    public EsocFornecedorProducaoRural(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
        this.valorBrutoAquisicao = 0.0;
        this.notasAqProdRural = new ArrayList<NotaAquisicaoProdRural>();
        this.preEventosReinf = new ArrayList<ReinfPreEvento>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ESOC_FORN_AQ_PROD_RURAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_FORN_AQ_PROD_RURAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_AQ_PROD_RURAL", foreignKey=@ForeignKey(name="FK_ESOC_FORNECEDOR_PRODUCAO_RUR"))
    public EsocAquisicaoProducaoRural getEsocAquisicao() {
        return this.esocAquisicao;
    }

    public void setEsocAquisicao(EsocAquisicaoProducaoRural esocAquisicao) {
        this.esocAquisicao = esocAquisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR", foreignKey=@ForeignKey(name="FK_ESOC_AQUISI_FORNECEDOR"))
    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Column(name="VALOR_BRUTO_AQUISICAO", precision=15, scale=2)
    public Double getValorBrutoAquisicao() {
        return this.valorBrutoAquisicao;
    }

    public void setValorBrutoAquisicao(Double valorBrutoAquisicao) {
        this.valorBrutoAquisicao = valorBrutoAquisicao;
    }

    @OneToMany(mappedBy="fornecedorProdRural", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<NotaAquisicaoProdRural> getNotasAqProdRural() {
        return this.notasAqProdRural;
    }

    public void setNotasAqProdRural(List<NotaAquisicaoProdRural> notasAqProdRural) {
        this.notasAqProdRural = notasAqProdRural;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reinf_aquisicao")
    public ReinfAquisicaoProdRural getReinfAquisicao() {
        return this.reinfAquisicao;
    }

    public void setReinfAquisicao(ReinfAquisicaoProdRural reinfAquisicao) {
        this.reinfAquisicao = reinfAquisicao;
    }

    @Override
    @OneToMany(mappedBy="aquisicaoFornecedor", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getFornecedor()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

