/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosEventoCooperado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EVENTO_COOPERADO", uniqueConstraints={@UniqueConstraint(name="UNQ1_EVENTO_COOPERADO", columnNames={"DESCRICAO"})})
public class EventoCooperado
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private Short debCred = 0;
    private Short repasse = 0;
    private PlanoContaGerencial planoContaGerencial;
    private TipoDoc tipoDoc;
    private HistoricoPadrao historicoPadrao;
    private Short contabilizarEvento = 0;
    private PlanoConta planoContaContabil;
    private PlanoConta planoContaContabilCredito;
    private PlanoConta planoContaContabilDebito;
    private MeioPagamento meioPagamento;
    private Double percJuros = 0.0;
    private Double percDesconto = 0.0;
    private Double percJurosRepasse = 0.0;
    private Double percDescontoRepasse = 0.0;
    private PlanoConta planoContaContabilRepasse;
    private PlanoContaGerencial planoContaGerencialRepasse;
    private List<TipoValoresTitulosEventoCooperado> tipoValoresTitulosEventoCooperado = new ArrayList<TipoValoresTitulosEventoCooperado>();
    private ClassificacaoClientes classificacaoPessoa;
    private ClassificacaoClientes classificacaoPessoaRepasse;

    @Id
    @Column(nullable=false, name="ID_EVENTO_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EVENTO_COOP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DEB_CRED")
    public Short getDebCred() {
        return this.debCred;
    }

    public void setDebCred(Short debCred) {
        this.debCred = debCred;
    }

    @Column(name="REPASSE")
    public Short getRepasse() {
        return this.repasse;
    }

    public void setRepasse(Short repasse) {
        this.repasse = repasse;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CONTABIL", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_1"))
    public PlanoConta getPlanoContaContabil() {
        return this.planoContaContabil;
    }

    public void setPlanoContaContabil(PlanoConta planoContaContabil) {
        this.planoContaContabil = planoContaContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_2"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_TIPO_DOC"))
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_HIST_PADRAO"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    @Column(name="CONTABILIZAR_EVENTO")
    public Short getContabilizarEvento() {
        return this.contabilizarEvento;
    }

    public void setContabilizarEvento(Short contabilizarEvento) {
        this.contabilizarEvento = contabilizarEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CONT_CREDITO", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_FK"))
    public PlanoConta getPlanoContaContabilCredito() {
        return this.planoContaContabilCredito;
    }

    public void setPlanoContaContabilCredito(PlanoConta planoContaContabilCredito) {
        this.planoContaContabilCredito = planoContaContabilCredito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CONT_DEBITO", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_FK_1"))
    public PlanoConta getPlanoContaContabilDebito() {
        return this.planoContaContabilDebito;
    }

    public void setPlanoContaContabilDebito(PlanoConta planoContaContabilDebito) {
        this.planoContaContabilDebito = planoContaContabilDebito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_MEIO_PAG"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="PERC_JUROS", precision=15, scale=4)
    public Double getPercJuros() {
        return this.percJuros;
    }

    public void setPercJuros(Double percJuros) {
        this.percJuros = percJuros;
    }

    @Column(name="PERC_DESCONTO", precision=15, scale=4)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(name="PERC_JUROS_REPASSE", precision=15, scale=4)
    public Double getPercJurosRepasse() {
        return this.percJurosRepasse;
    }

    public void setPercJurosRepasse(Double percJurosRepasse) {
        this.percJurosRepasse = percJurosRepasse;
    }

    @Column(name="PERC_DESCONTO_REPASSE", precision=15, scale=4)
    public Double getPercDescontoRepasse() {
        return this.percDescontoRepasse;
    }

    public void setPercDescontoRepasse(Double percDescontoRepasse) {
        this.percDescontoRepasse = percDescontoRepasse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_REPASSE", foreignKey=@ForeignKey(name=""))
    public PlanoConta getPlanoContaContabilRepasse() {
        return this.planoContaContabilRepasse;
    }

    public void setPlanoContaContabilRepasse(PlanoConta planoContaContabilRepasse) {
        this.planoContaContabilRepasse = planoContaContabilRepasse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GER_REPASSE", foreignKey=@ForeignKey(name="FK_EV_COOP_PLANO_GER_REPASSE"))
    public PlanoContaGerencial getPlanoContaGerencialRepasse() {
        return this.planoContaGerencialRepasse;
    }

    public void setPlanoContaGerencialRepasse(PlanoContaGerencial planoContaGerencialRepasse) {
        this.planoContaGerencialRepasse = planoContaGerencialRepasse;
    }

    @OneToMany(mappedBy="eventoCooperado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoValoresTitulosEventoCooperado> getTipoValoresTitulosEventoCooperado() {
        return this.tipoValoresTitulosEventoCooperado;
    }

    public void setTipoValoresTitulosEventoCooperado(List<TipoValoresTitulosEventoCooperado> tipoValoresTitulosEventoCooperado) {
        this.tipoValoresTitulosEventoCooperado = tipoValoresTitulosEventoCooperado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_CL_PES"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA_REPASSE", foreignKey=@ForeignKey(name="FK_EVENTO_COOPERADO_CL_PES_REP"))
    public ClassificacaoClientes getClassificacaoPessoaRepasse() {
        return this.classificacaoPessoaRepasse;
    }

    public void setClassificacaoPessoaRepasse(ClassificacaoClientes classificacaoPessoaRepasse) {
        this.classificacaoPessoaRepasse = classificacaoPessoaRepasse;
    }
}

