/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoEvtOsPCP;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOSProdLinMultGC;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="EVENTO_OS_PROD_L_MULT")
public class EventoOSProdLinMult
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<EventoOSProdLinMultGC> eventos = new ArrayList<EventoOSProdLinMultGC>();
    private Empresa empresa;
    private TipoEvento tipoEvento;
    private TurnoDeTrabalho turnoDeTrabalho;
    private Short tipoApontEvento = 5;
    private ClassificacaoEvtOsPCP classificacaoEvento;
    private Date dataInicial;
    private Date dataFinal;
    private Colaborador colaborador;

    @Id
    @Column(nullable=false, unique=true, name="ID_EVENTO_OS_PROD_L_MULT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_OS_PROD_L_MULT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="eventoOSProdLinMult")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<EventoOSProdLinMultGC> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<EventoOSProdLinMultGC> eventos) {
        this.eventos = eventos;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EVT_OS_PR_L_PR_MUL_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_TIPO_EVENTO", foreignKey=@ForeignKey(name="FK_EVT_OS_PR_L_PR_MUL_TP_EVT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEvento getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEvento tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TURNO_DE_TRABALHO", foreignKey=@ForeignKey(name="FK_EVT_OS_PR_L_PR_MUL_TURN_TR"))
    public TurnoDeTrabalho getTurnoDeTrabalho() {
        return this.turnoDeTrabalho;
    }

    public void setTurnoDeTrabalho(TurnoDeTrabalho turnoDeTrabalho) {
        this.turnoDeTrabalho = turnoDeTrabalho;
    }

    @Column(name="TIPO_APONT_EVENTO")
    public Short getTipoApontEvento() {
        return this.tipoApontEvento;
    }

    public void setTipoApontEvento(Short tipoApontEvento) {
        this.tipoApontEvento = tipoApontEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_EVT_OS_LIN_PR", foreignKey=@ForeignKey(name="FK_EVT_OS_PR_L_PR_MUL_CL_EVT"))
    public ClassificacaoEvtOsPCP getClassificacaoEvento() {
        return this.classificacaoEvento;
    }

    public void setClassificacaoEvento(ClassificacaoEvtOsPCP classificacaoEvento) {
        this.classificacaoEvento = classificacaoEvento;
    }

    @Column(nullable=false, name="DATA_INICIAL")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(nullable=false, name="DATA_FINAL")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Evento Linha Multiplas OS {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_EVT_OS_PR_L_PR_MUL_COLAB"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }
}

