/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormaPagamento;
import com.touchcomp.basementor.model.vo.ItemCompFreteEventosTransAgreg;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="EVENTO_TRANSP_AGREGADO", uniqueConstraints={@UniqueConstraint(name="UNQ1_EVENTO_TRANSP_AGREGADO", columnNames={"DESCRICAO"})})
public class EventoTranspAgregado
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Short tipoEvento = 0;
    private String formula;
    private PlanoContaGerencial planocontaGerencial;
    private Empresa empresa;
    private Date dataCadastro;
    private Short tipoIncidencia = 0;
    private Timestamp dataAtualizacao;
    private List<ItemCompFreteEventosTransAgreg> componentesFrete = new ArrayList<ItemCompFreteEventosTransAgreg>();
    private Short ativo = 1;
    private FormaPagamento formaPagamento;
    private Short infEventoAutList = 0;

    @Id
    @Column(name="ID_EVENTO_TRANSP_AGREGADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_TRANSP_AGREGADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DESCRICAO", length=80)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="FORMULA", length=1000)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_EVENTO_TRANSP_AGREG_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanocontaGerencial() {
        return this.planocontaGerencial;
    }

    public void setPlanocontaGerencial(PlanoContaGerencial planocontaGerencial) {
        this.planocontaGerencial = planocontaGerencial;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EVENTO_TRANSP_AGREG_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="TIPO_EVENTO")
    public Short getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(Short tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @OneToMany(mappedBy="eventoTranspAgregado", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @Fetch(value=FetchMode.SELECT)
    public List<ItemCompFreteEventosTransAgreg> getComponentesFrete() {
        return this.componentesFrete;
    }

    public void setComponentesFrete(List<ItemCompFreteEventosTransAgreg> componentesFrete) {
        this.componentesFrete = componentesFrete;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_INCIDENCIA")
    public Short getTipoIncidencia() {
        return this.tipoIncidencia;
    }

    public void setTipoIncidencia(Short tipoIncidencia) {
        this.tipoIncidencia = tipoIncidencia;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_EVENTO_TRANSP_AGREG_FORM_PAG"))
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Column(name="INF_EVENTO_AUT_LIST")
    public Short getInfEventoAutList() {
        return this.infEventoAutList;
    }

    public void setInfEventoAutList(Short infEventoAutList) {
        this.infEventoAutList = infEventoAutList;
    }
}

