/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemExclusaoLancamentoFolha;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EXCLUSAO_LANCAMENTO_FOLHA")
public class ExclusaoLancamentoFolha
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuario;
    private String motivo;
    private TipoCalculoEvento tipoCalculoEvento;
    private String dadosAberturaPeriodo;
    private Short excluirFolhaFechada = 0;
    private Sindicato sindicato;
    private CentroCusto centroCusto;
    private List<ItemExclusaoLancamentoFolha> itensExclusoes = new ArrayList<ItemExclusaoLancamentoFolha>();

    @Id
    @Column(nullable=false, unique=true, name="ID_EXCLUSAO_LANCAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EXCLUSAO_LANCAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EXCLUSAO_LANCAMENTO_FOLHA_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_EXCLUSAO_LANCAMENTO_FOLHA_2"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="MOTIVO", length=100)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_EXCLUSAO_LANCAMENTO_FOLHA_3"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="DADOS_ABERTURA_PERIODO", length=100)
    public String getDadosAberturaPeriodo() {
        return this.dadosAberturaPeriodo;
    }

    public void setDadosAberturaPeriodo(String dadosAberturaPeriodo) {
        this.dadosAberturaPeriodo = dadosAberturaPeriodo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDadosAberturaPeriodo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="EXCLUIR_FOLHA_FECHADA")
    public Short getExcluirFolhaFechada() {
        return this.excluirFolhaFechada;
    }

    public void setExcluirFolhaFechada(Short excluirFolhaFechada) {
        this.excluirFolhaFechada = excluirFolhaFechada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SINDICATO", foreignKey=@ForeignKey(name="FK_SINDICATO_EXCLUSAO_LANC_FOLH"))
    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicato = sindicato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_EXCLUSAO_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="exclusao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemExclusaoLancamentoFolha> getItensExclusoes() {
        return this.itensExclusoes;
    }

    public void setItensExclusoes(List<ItemExclusaoLancamentoFolha> itensExclusoes) {
        this.itensExclusoes = itensExclusoes;
    }
}

