/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EXECUTANTE")
public class Executante
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Pessoa pessoa;
    private Colaborador colaborador;
    private Timestamp dataHoraInicio;
    private Timestamp dataHoraFinal;
    private Double tempo = 0.0;
    private FechamentoOrdemServico fechamentoOrdemServico;
    private Double valorHora = 0.0;
    private Double valorTotal = 0.0;
    private Double valorAdicional = 0.0;
    private Date dataExecucao;
    private String rdo;
    private Date primeiraEntrada;
    private Date primeiraSaida;
    private Date segundaEntrada;
    private Date segundaSaida;
    private Double horasTrabalhadas = 0.0;
    private Double cargaHoraria = 0.0;
    private Double horasExtras = 0.0;
    private Double percentual = 0.0;
    private Double horasNoturna = 0.0;
    private Double valorHoraExterno = 0.0;
    private Double valorHoraExtraInterno = 0.0;
    private Double valorHoraExtraExterno = 0.0;
    private Double valorTotalnterno = 0.0;
    private Double valorTotalExterno = 0.0;
    private Double intervalo = 0.0;
    private Double valorHoraNoturna = 0.0;
    private Double valorHoraNoturnaInterna = 0.0;
    private LancamentoCtbGerencial lancamentoCtbGerencial;

    @Id
    @Column(nullable=false, name="ID_EXECUTANTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EXECUTANTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EXECUTANTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_EXECUTANTE_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_EXECUTANTE_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="DATA_HORA_INICIO")
    public Timestamp getDataHoraInicio() {
        return this.dataHoraInicio;
    }

    public void setDataHoraInicio(Timestamp dataHoraInicio) {
        this.dataHoraInicio = dataHoraInicio;
    }

    @Column(name="DATA_HORA_FIM")
    public Timestamp getDataHoraFinal() {
        return this.dataHoraFinal;
    }

    public void setDataHoraFinal(Timestamp dataHoraFinal) {
        this.dataHoraFinal = dataHoraFinal;
    }

    @Column(name="TEMPO", precision=15, scale=6)
    public Double getTempo() {
        return this.tempo;
    }

    public void setTempo(Double tempo) {
        this.tempo = tempo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAMENTO_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_EXECUTANTE_FECH_OS"))
    public FechamentoOrdemServico getFechamentoOrdemServico() {
        return this.fechamentoOrdemServico;
    }

    public void setFechamentoOrdemServico(FechamentoOrdemServico fechamentoOrdemServico) {
        this.fechamentoOrdemServico = fechamentoOrdemServico;
    }

    @Column(name="VALOR_HORA", precision=15, scale=2)
    public Double getValorHora() {
        return this.valorHora;
    }

    public void setValorHora(Double valorHora) {
        this.valorHora = valorHora;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(nullable=false, name="VALOR_ADICIONAL", precision=15, scale=2)
    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(targetEntity=LancamentoCtbGerencial.class, optional=true, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_LANCAMENTO_CTB_GERENCIAL", foreignKey=@ForeignKey(name="FK_EXECUTANTE_LANC_CTB_GER"))
    public LancamentoCtbGerencial getLancamentoCtbGerencial() {
        return this.lancamentoCtbGerencial;
    }

    public void setLancamentoCtbGerencial(LancamentoCtbGerencial lancamentoCtbGerencial) {
        this.lancamentoCtbGerencial = lancamentoCtbGerencial;
    }

    @Column(name="data_execucao")
    @Temporal(value=TemporalType.DATE)
    public Date getDataExecucao() {
        return this.dataExecucao;
    }

    public void setDataExecucao(Date dataExecucao) {
        this.dataExecucao = dataExecucao;
    }

    @Column(name="RDO")
    public String getRdo() {
        return this.rdo;
    }

    public void setRdo(String rdo) {
        this.rdo = rdo;
    }

    @Column(name="primeira_entrada")
    @Temporal(value=TemporalType.TIME)
    public Date getPrimeiraEntrada() {
        return this.primeiraEntrada;
    }

    public void setPrimeiraEntrada(Date primeiraEntrada) {
        this.primeiraEntrada = primeiraEntrada;
    }

    @Column(name="primeira_saida")
    @Temporal(value=TemporalType.TIME)
    public Date getPrimeiraSaida() {
        return this.primeiraSaida;
    }

    public void setPrimeiraSaida(Date primeiraSaida) {
        this.primeiraSaida = primeiraSaida;
    }

    @Column(name="segunda_entrada")
    @Temporal(value=TemporalType.TIME)
    public Date getSegundaEntrada() {
        return this.segundaEntrada;
    }

    public void setSegundaEntrada(Date segundaEntrada) {
        this.segundaEntrada = segundaEntrada;
    }

    @Column(name="segunda_saida")
    @Temporal(value=TemporalType.TIME)
    public Date getSegundaSaida() {
        return this.segundaSaida;
    }

    public void setSegundaSaida(Date segundaSaida) {
        this.segundaSaida = segundaSaida;
    }

    @Column(name="horas_trabalhadas")
    public Double getHorasTrabalhadas() {
        return this.horasTrabalhadas;
    }

    public void setHorasTrabalhadas(Double horasTrabalhadas) {
        this.horasTrabalhadas = horasTrabalhadas;
    }

    @Column(name="carga_horaria")
    public Double getCargaHoraria() {
        return this.cargaHoraria;
    }

    public void setCargaHoraria(Double cargaHoraria) {
        this.cargaHoraria = cargaHoraria;
    }

    @Column(name="horas_extras")
    public Double getHorasExtras() {
        return this.horasExtras;
    }

    public void setHorasExtras(Double horasExtras) {
        this.horasExtras = horasExtras;
    }

    @Column(name="percentual")
    public Double getPercentual() {
        return this.percentual;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    @Column(name="horas_noturna")
    public Double getHorasNoturna() {
        return this.horasNoturna;
    }

    public void setHorasNoturna(Double horasNoturna) {
        this.horasNoturna = horasNoturna;
    }

    @Column(name="valor_hora_externo")
    public Double getValorHoraExterno() {
        return this.valorHoraExterno;
    }

    public void setValorHoraExterno(Double valorHoraExterno) {
        this.valorHoraExterno = valorHoraExterno;
    }

    @Column(name="valor_hora_extra_int")
    public Double getValorHoraExtraInterno() {
        return this.valorHoraExtraInterno;
    }

    public void setValorHoraExtraInterno(Double valorHoraExtraInterno) {
        this.valorHoraExtraInterno = valorHoraExtraInterno;
    }

    @Column(name="valor_hora_extra_ext")
    public Double getValorHoraExtraExterno() {
        return this.valorHoraExtraExterno;
    }

    public void setValorHoraExtraExterno(Double valorHoraExtraExterno) {
        this.valorHoraExtraExterno = valorHoraExtraExterno;
    }

    @Column(name="intervalo")
    public Double getIntervalo() {
        return this.intervalo;
    }

    public void setIntervalo(Double intervalo) {
        this.intervalo = intervalo;
    }

    @Column(name="valor_total_interno")
    public Double getValorTotalnterno() {
        return this.valorTotalnterno;
    }

    public void setValorTotalnterno(Double valorTotalnterno) {
        this.valorTotalnterno = valorTotalnterno;
    }

    @Column(name="valor_total_externo")
    public Double getValorTotalExterno() {
        return this.valorTotalExterno;
    }

    public void setValorTotalExterno(Double valorTotalExterno) {
        this.valorTotalExterno = valorTotalExterno;
    }

    @Column(name="valor_hora_noturna")
    public Double getValorHoraNoturna() {
        return this.valorHoraNoturna;
    }

    public void setValorHoraNoturna(Double valorHoraNoturna) {
        this.valorHoraNoturna = valorHoraNoturna;
    }

    @Column(name="valor_hora_noturna_interna")
    public Double getValorHoraNoturnaInterna() {
        return this.valorHoraNoturnaInterna;
    }

    public void setValorHoraNoturnaInterna(Double valorHoraNoturnaInterna) {
        this.valorHoraNoturnaInterna = valorHoraNoturnaInterna;
    }
}

