/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPed;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ExpedicaoItemProdLoteFab;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PackingEmbalagemProducaoOS;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EXPEDICAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_EXPEDICAO", columnNames={"ID_PEDIDO"})})
public class Expedicao
implements InterfaceVO {
    private Long identificador;
    private Pedido pedido;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Usuario usuario;
    private List<EmbalagemExpedicao> embalagemExpedicao = new ArrayList<EmbalagemExpedicao>();
    private NotaFiscalPropria notaFiscalPropria;
    private Short conferida = 0;
    private Short tipoConferencia = 1;
    private String justificativa;
    private PreFaturamentoPed preFaturamentoPed;
    private List<PackingEmbalagemProducaoOS> packingEmbalagemProducaoOS = new ArrayList<PackingEmbalagemProducaoOS>();
    private List<ExpedicaoItemProdLoteFab> prodLotesFab = new ArrayList<ExpedicaoItemProdLoteFab>();
    private PreFaturamentoNF preFaturamentoNF;
    private Short origem = 0;
    private WmsPedido wmsPedido;

    @Id
    @Column(nullable=false, unique=true, name="ID_EXPEDICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EXPEDICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_EXPEDICAO_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EXPEDICAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="expedicao", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EmbalagemExpedicao> getEmbalagemExpedicao() {
        return this.embalagemExpedicao;
    }

    public void setEmbalagemExpedicao(List<EmbalagemExpedicao> embalagemExpedicao) {
        this.embalagemExpedicao = embalagemExpedicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getPedido() != null) {
            return ToolBaseMethodsVO.toString((String)"ID.: {0} Pedido: {1} Unidade: {2}", (Object[])new Object[]{this.getIdentificador(), this.getPedido().getIdentificador(), this.getPedido().getUnidadeFatCliente()});
        }
        return ToolBaseMethodsVO.toString((String)"ID.: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="expedicao", fetch=FetchType.LAZY)
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_EXPEDICAO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="CONFERIDA")
    public Short getConferida() {
        return this.conferida;
    }

    public void setConferida(Short conferida) {
        this.conferida = conferida;
    }

    @Transient
    @OneToOne(mappedBy="expedicao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public PreFaturamentoPed getPreFaturamentoPed() {
        return this.preFaturamentoPed;
    }

    public void setPreFaturamentoPed(PreFaturamentoPed preFaturamentoPed) {
        this.preFaturamentoPed = preFaturamentoPed;
    }

    @OneToMany(mappedBy="expedicao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<PackingEmbalagemProducaoOS> getPackingEmbalagemProducaoOS() {
        return this.packingEmbalagemProducaoOS;
    }

    public void setPackingEmbalagemProducaoOS(List<PackingEmbalagemProducaoOS> packingEmbalagemProducaoOS) {
        this.packingEmbalagemProducaoOS = packingEmbalagemProducaoOS;
    }

    @OneToMany(mappedBy="expedicao")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ExpedicaoItemProdLoteFab> getProdLotesFab() {
        return this.prodLotesFab;
    }

    public void setProdLotesFab(List<ExpedicaoItemProdLoteFab> prodLotesFab) {
        this.prodLotesFab = prodLotesFab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FAT_NF", foreignKey=@ForeignKey(name="FK_EXPEDICAO_PRE_FAT_NF"))
    public PreFaturamentoNF getPreFaturamentoNF() {
        return this.preFaturamentoNF;
    }

    public void setPreFaturamentoNF(PreFaturamentoNF preFaturamentoNF) {
        this.preFaturamentoNF = preFaturamentoNF;
    }

    @Column(name="ORIGEM")
    public Short getOrigem() {
        return this.origem;
    }

    public void setOrigem(Short origem) {
        this.origem = origem;
    }

    @Column(name="TIPO_CONFERENCIA")
    public Short getTipoConferencia() {
        return this.tipoConferencia;
    }

    public void setTipoConferencia(Short tipoConferencia) {
        this.tipoConferencia = tipoConferencia;
    }

    @Column(name="JUSTIFICATIVA", length=500)
    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @OneToOne(mappedBy="expedicao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public WmsPedido getWmsPedido() {
        return this.wmsPedido;
    }

    public void setWmsPedido(WmsPedido wmsPedido) {
        this.wmsPedido = wmsPedido;
    }
}

