/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoColaboradorVT;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FECHAMENTO_BENEFICIO_VT")
public class FechamentoBeneficioVT
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short filtrarEmpresaLogada = 0;
    private Date periodoPagamento;
    private Date periodoInicioApuracao;
    private Date periodoFinalApuracao;
    private List<FechamentoColaboradorVT> fechamentos = new ArrayList<FechamentoColaboradorVT>();
    private PeriodoFolhaPagamento periodoFolhaPagamento;

    @Id
    @Column(nullable=false, unique=true, name="ID_FECHAMENTO_BEN_VT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FECHAMENTO_BEN_VT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FECHAMENTO_BEN_VT_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="FILTRAR_EMPRESA_LOGADA")
    public Short getFiltrarEmpresaLogada() {
        return this.filtrarEmpresaLogada;
    }

    public void setFiltrarEmpresaLogada(Short filtrarEmpresaLogada) {
        this.filtrarEmpresaLogada = filtrarEmpresaLogada;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_PAGAMENTO")
    public Date getPeriodoPagamento() {
        return this.periodoPagamento;
    }

    public void setPeriodoPagamento(Date periodoPagamento) {
        this.periodoPagamento = periodoPagamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_INICIO_APURACAO")
    public Date getPeriodoInicioApuracao() {
        return this.periodoInicioApuracao;
    }

    public void setPeriodoInicioApuracao(Date periodoInicioApuracao) {
        this.periodoInicioApuracao = periodoInicioApuracao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_FINAL_APURACAO")
    public Date getPeriodoFinalApuracao() {
        return this.periodoFinalApuracao;
    }

    public void setPeriodoFinalApuracao(Date periodoFinalApuracao) {
        this.periodoFinalApuracao = periodoFinalApuracao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="fechamentoBeneficioVT", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FechamentoColaboradorVT> getFechamentos() {
        return this.fechamentos;
    }

    public void setFechamentos(List<FechamentoColaboradorVT> fechamentos) {
        this.fechamentos = fechamentos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_FOLHA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_FECH_BENEF_VT_PER_FOLHA_PAG"))
    public PeriodoFolhaPagamento getPeriodoFolhaPagamento() {
        return this.periodoFolhaPagamento;
    }

    public void setPeriodoFolhaPagamento(PeriodoFolhaPagamento periodoFolhaPagamento) {
        this.periodoFolhaPagamento = periodoFolhaPagamento;
    }
}

