/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoCooperado;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.LancContAdicDocFinanceiro;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GERACAO_TITULOS")
public class GeracaoTitulos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private CarteiraCobranca carteiraCobranca;
    private Pessoa pessoa;
    private CentroCusto centroCusto;
    private PlanoConta planoConta;
    private PlanoContaGerencial planoContaGerencial;
    private Short pagRec = 0;
    private Short tipoTitulo = 0;
    private Date dataEmissao;
    private Date dataEntrada;
    private Date dataCompetencia;
    private Double valorTitulo = 0.0;
    private Integer nrParcelas = 0;
    private Integer diasEntreParcelas = 0;
    private Short tipoGeracao = 0;
    private Short variarDtCompVenc = 0;
    private TipoDoc tipoDoc;
    private LancContAdicDocFinanceiro lancContAdicDocFinanc;
    private String observacao;
    private String descricao;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Double desconto = 0.0;
    private Double percentualJuros = 0.0;
    private Double jurosEmbutidos = 0.0;
    private Short tipoPesquisa = 0;
    private GrupoPessoas grupoPessoas;
    private Date dataVencimentoInicial;
    private Short antecipado = 0;
    private EventoCooperado eventoCooperado;
    private List<LancamentoEventoCooperado> lancamentosEventos = new ArrayList<LancamentoEventoCooperado>();
    private Date dataLimiteDesconto;
    private Double percentualMulta = 0.0;
    private MeioPagamento meioPagamento;
    private ClassificacaoClientes classificacaoPessoa;
    private Short variarDataCompetencia = 0;
    private Short variarDataEmissao = 0;
    private Short variarDataEntSai = 0;
    private String nrDocOrigem;
    private Short gerarDatasFixas = 0;
    private Short gerarLancCooperado = 0;
    private Short gerarEvtCooperado = 0;

    @Id
    @Column(name="ID_GERACAO_TITULOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GERACAO_TITULOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_CART_COBRANC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_CEN_CUSTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_PLANO_CONTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_PC_GERENCIAL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Column(name="TIPO_TITULO")
    public Short getTipoTitulo() {
        return this.tipoTitulo;
    }

    public void setTipoTitulo(Short tipoTitulo) {
        this.tipoTitulo = tipoTitulo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPETENCIA")
    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
    }

    @Column(nullable=false, name="VALOR_TITULO", precision=15, scale=2)
    public Double getValorTitulo() {
        return this.valorTitulo;
    }

    public void setValorTitulo(Double valorTitulo) {
        this.valorTitulo = valorTitulo;
    }

    @Column(name="NR_PARCELAS")
    public Integer getNrParcelas() {
        return this.nrParcelas;
    }

    public void setNrParcelas(Integer nrParcelas) {
        this.nrParcelas = nrParcelas;
    }

    @Column(name="DIAS_ENTRE_PARCELAS")
    public Integer getDiasEntreParcelas() {
        return this.diasEntreParcelas;
    }

    public void setDiasEntreParcelas(Integer diasEntreParcelas) {
        this.diasEntreParcelas = diasEntreParcelas;
    }

    @Column(name="TIPO_GERACAO")
    public Short getTipoGeracao() {
        return this.tipoGeracao;
    }

    public void setTipoGeracao(Short tipoGeracao) {
        this.tipoGeracao = tipoGeracao;
    }

    @Column(name="VARIAR_DT_COMP_VENC")
    public Short getVariarDtCompVenc() {
        return this.variarDtCompVenc;
    }

    public void setVariarDtCompVenc(Short variarDtCompVenc) {
        this.variarDtCompVenc = variarDtCompVenc;
    }

    @JoinColumn(name="ID_TIPO_DOC", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_TP_DOC_FINAN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="geracaoTitulos", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="DESCONTO", precision=15, scale=2)
    public Double getDesconto() {
        return this.desconto;
    }

    public void setDesconto(Double desconto) {
        this.desconto = desconto;
    }

    @Column(nullable=false, name="PERCENTUAL_JUROS", precision=15, scale=2)
    public Double getPercentualJuros() {
        return this.percentualJuros;
    }

    public void setPercentualJuros(Double percentualJuros) {
        this.percentualJuros = percentualJuros;
    }

    @Column(nullable=false, name="JUROS_EMBUTIDOS", precision=15, scale=2)
    public Double getJurosEmbutidos() {
        return this.jurosEmbutidos;
    }

    public void setJurosEmbutidos(Double jurosEmbutidos) {
        this.jurosEmbutidos = jurosEmbutidos;
    }

    @Column(name="TIPO_PESQUISA")
    public Short getTipoPesquisa() {
        return this.tipoPesquisa;
    }

    public void setTipoPesquisa(Short tipoPesquisa) {
        this.tipoPesquisa = tipoPesquisa;
    }

    @JoinColumn(name="ID_GRUPO_PESSOA", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_GRUPO_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoPessoas getGrupoPessoas() {
        return this.grupoPessoas;
    }

    public void setGrupoPessoas(GrupoPessoas grupoPessoas) {
        this.grupoPessoas = grupoPessoas;
    }

    @Column(name="DATA_VENCIMENTO_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    public void setDataVencimentoInicial(Date dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANC_CONT_ADIC_DOC_FINANC", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_LANC_AD_D_F"))
    public LancContAdicDocFinanceiro getLancContAdicDocFinanc() {
        return this.lancContAdicDocFinanc;
    }

    public void setLancContAdicDocFinanc(LancContAdicDocFinanceiro lancContAdicDocFinanc) {
        this.lancContAdicDocFinanc = lancContAdicDocFinanc;
    }

    @Column(name="ANTECIPADO")
    public Short getAntecipado() {
        return this.antecipado;
    }

    public void setAntecipado(Short antecipado) {
        this.antecipado = antecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_COOPERADO", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_EVENTO_COOP"))
    public EventoCooperado getEventoCooperado() {
        return this.eventoCooperado;
    }

    public void setEventoCooperado(EventoCooperado eventoCooperado) {
        this.eventoCooperado = eventoCooperado;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="geracaoTitulo")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LancamentoEventoCooperado> getLancamentosEventos() {
        return this.lancamentosEventos;
    }

    public void setLancamentosEventos(List<LancamentoEventoCooperado> lancamentosEventos) {
        this.lancamentosEventos = lancamentosEventos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIMITE_DESCONTO")
    public Date getDataLimiteDesconto() {
        return this.dataLimiteDesconto;
    }

    public void setDataLimiteDesconto(Date dataLimiteDesconto) {
        this.dataLimiteDesconto = dataLimiteDesconto;
    }

    @Column(nullable=false, name="PERCENTUAL_MULTA", precision=15, scale=2)
    public Double getPercentualMulta() {
        return this.percentualMulta;
    }

    public void setPercentualMulta(Double percentualMulta) {
        this.percentualMulta = percentualMulta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_GERACAO_TITULOS_MEIO_PAG"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_GERACAO_TIT_CLASSIF_PESSOA"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA")
    public Date getDataEntrada() {
        return this.dataEntrada;
    }

    public void setDataEntrada(Date dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Column(name="VARIAR_DATA_COMPENTENCIA")
    public Short getVariarDataCompetencia() {
        return this.variarDataCompetencia;
    }

    public void setVariarDataCompetencia(Short variarDataCompetencia) {
        this.variarDataCompetencia = variarDataCompetencia;
    }

    @Column(name="VARIAR_DATA_EMISSAO")
    public Short getVariarDataEmissao() {
        return this.variarDataEmissao;
    }

    public void setVariarDataEmissao(Short variarDataEmissao) {
        this.variarDataEmissao = variarDataEmissao;
    }

    @Column(name="VARIAR_DATA_ENT_SAIDA")
    public Short getVariarDataEntSai() {
        return this.variarDataEntSai;
    }

    public void setVariarDataEntSai(Short variarDataEntSai) {
        this.variarDataEntSai = variarDataEntSai;
    }

    @Column(name="NR_DOC_ORIGEM")
    public String getNrDocOrigem() {
        return this.nrDocOrigem;
    }

    public void setNrDocOrigem(String nrDocOrigem) {
        this.nrDocOrigem = nrDocOrigem;
    }

    @Column(name="GERAR_DATAS_FIXAS")
    public Short getGerarDatasFixas() {
        return this.gerarDatasFixas;
    }

    public void setGerarDatasFixas(Short gerarDatasFixas) {
        this.gerarDatasFixas = gerarDatasFixas;
    }

    @Column(name="GERAR_LANC_COOPERADO")
    public Short getGerarLancCooperado() {
        return this.gerarLancCooperado;
    }

    public void setGerarLancCooperado(Short gerarLancCooperado) {
        this.gerarLancCooperado = gerarLancCooperado;
    }

    @Column(name="GERAR_EVT_COOPERADO")
    public Short getGerarEvtCooperado() {
        return this.gerarEvtCooperado;
    }

    public void setGerarEvtCooperado(Short gerarEvtCooperado) {
        this.gerarEvtCooperado = gerarEvtCooperado;
    }
}

