/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRADE_ITEM_NOTA_TERCEIROS")
public class GradeItemNotaTerceiros
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private Double valorCusto;
    private Date dataEntradaSaida;
    private Short movimentacaoFisica;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private ItemNotaTerceiros itemNotaTerceiros;
    private EstoqueTerceiros estoqueTerceiros;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;
    private Double fatorConversao;
    private Double valorTransfFiscal;
    private Double valorUltPrecoCompra;
    private Short auxTrigger;

    public GradeItemNotaTerceiros() {
        this.setQuantidade(0.0);
        this.setMovimentacaoFisica((short)0);
        this.setValorCusto(0.0);
        this.quantidade = 0.0;
        this.valorCusto = 0.0;
        this.valorTransfFiscal = 0.0;
        this.valorUltPrecoCompra = 0.0;
        this.fatorConversao = 0.0;
        this.movimentacaoFisica = 0;
        this.auxTrigger = 0;
    }

    public GradeItemNotaTerceiros(GradeCor grade) {
        this();
        this.gradeCor = grade;
    }

    @Id
    @Column(name="ID_GRADE_ITEM_NOTA_TERCEIROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_NOTA_TERCEIROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @Column(name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NT_GRADE_COR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NT_TERCEIROS_LOTE"))
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @JoinColumn(nullable=false, name="ID_ITEM_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NT_ITEM_NOTA_TERC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemNotaTerceiros getItemNotaTerceiros() {
        return this.itemNotaTerceiros;
    }

    public void setItemNotaTerceiros(ItemNotaTerceiros itemNotaTerceiros) {
        this.itemNotaTerceiros = itemNotaTerceiros;
    }

    @Column(name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    @Column(name="DATA_ENTRADA_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="gradeItemNotaTerceiros", targetEntity=EstoqueTerceiros.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public EstoqueTerceiros getEstoqueTerceiros() {
        return this.estoqueTerceiros;
    }

    public void setEstoqueTerceiros(EstoqueTerceiros estoqueTerceiros) {
        this.estoqueTerceiros = estoqueTerceiros;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NT_TERCEIROS_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NT_TERCEIROS_C_ES"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Column(name="FATOR_CONVERSAO", precision=15, scale=6)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Column(name="VALOR_TRANSF_FISCAL", precision=15, scale=6)
    public Double getValorTransfFiscal() {
        return this.valorTransfFiscal;
    }

    public void setValorTransfFiscal(Double valorTransfFiscal) {
        this.valorTransfFiscal = valorTransfFiscal;
    }

    @Column(name="VALOR_ULT_PRECO_COMPRA", precision=15, scale=6)
    public Double getValorUltPrecoCompra() {
        return this.valorUltPrecoCompra;
    }

    public void setValorUltPrecoCompra(Double valorUltPrecoCompra) {
        this.valorUltPrecoCompra = valorUltPrecoCompra;
    }

    @Column(name="AUX_TRIGGER")
    public Short getAuxTrigger() {
        return this.auxTrigger;
    }

    public void setAuxTrigger(Short auxTrigger) {
        this.auxTrigger = auxTrigger;
    }
}

