/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="GRADE_ITEM_OC")
public class GradeItemOrdemCompra
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private GradeCor gradeCor;
    private ItemOrdemCompra itemOrdemCompra;
    private List<GradeItemRecepcaoMercadorias> gradeItemRecepcaoMercadorias;

    public GradeItemOrdemCompra() {
        this.quantidade = 0.0;
        this.gradeItemRecepcaoMercadorias = new ArrayList<GradeItemRecepcaoMercadorias>();
    }

    public GradeItemOrdemCompra(GradeCor grade) {
        this.gradeCor = grade;
        this.quantidade = 0.0;
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_OC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_OC")
    public Long getIdentificador() {
        return this.identificador;
    }

    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_OC_GRADE_COR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @JoinColumn(nullable=false, name="ID_ITEM_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_OC_ITEM_OC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemOrdemCompra getItemOrdemCompra() {
        return this.itemOrdemCompra;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=18, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @OneToMany(mappedBy="gradeItemOrdemCompra", fetch=FetchType.LAZY)
    public List<GradeItemRecepcaoMercadorias> getGradeItemRecepcaoMercadorias() {
        return this.gradeItemRecepcaoMercadorias;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setItemOrdemCompra(ItemOrdemCompra itemOrdemCompra) {
        this.itemOrdemCompra = itemOrdemCompra;
    }

    public void setGradeItemRecepcaoMercadorias(List<GradeItemRecepcaoMercadorias> gradeItemRecepcaoMercadorias) {
        this.gradeItemRecepcaoMercadorias = gradeItemRecepcaoMercadorias;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

