/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRADE_ITEM_RPS")
public class GradeItemRPS
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private Short movimentacaoFisica;

    public GradeItemRPS() {
        this.setQuantidade(0.0);
        this.quantidade = 0.0;
        this.movimentacaoFisica = 0;
    }

    public GradeItemRPS(GradeCor grade) {
        this.gradeCor = grade;
        this.setQuantidade(0.0);
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_RPS_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_RPS_LT_FAB"))
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH})
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }
}

