/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="GRUPO_APURACAO_LOCACAO")
public class GrupoApuracaoLocacao
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private List<ApuracaoLocacaoContrato> apuracaoLocacaoContrato = new ArrayList<ApuracaoLocacaoContrato>();
    private Cliente cliente;
    private ServicoRPS servico;
    private Date dataEmissao;
    private Double valorTotal = 0.0;
    private Double valorDescontos = 0.0;
    private Double totalAbatimentos = 0.0;
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private Rps rps;
    private NotaContratoLocacao nota;
    private Timestamp dataAtualizacao;
    private TomadorPrestadorRps tomador;

    @Id
    @Column(name="ID_GRUPO_APURACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_APURACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="grupoApuracao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<ApuracaoLocacaoContrato> getApuracaoLocacaoContrato() {
        return this.apuracaoLocacaoContrato;
    }

    public void setApuracaoLocacaoContrato(List<ApuracaoLocacaoContrato> apuracaoLocacaoContrato) {
        this.apuracaoLocacaoContrato = apuracaoLocacaoContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_APURACAO_LOC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToOne(targetEntity=Cliente.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_GRUPO_APURACAO_LOC_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @OneToOne(targetEntity=ServicoRPS.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO", foreignKey=@ForeignKey(name="FK_GRUPO_APURACAO_LOC_SERVICO"))
    public ServicoRPS getServico() {
        return this.servico;
    }

    public void setServico(ServicoRPS servico) {
        this.servico = servico;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=4)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(nullable=false, name="TOTAL_DESCONTOS", precision=15, scale=4)
    public Double getValorDescontos() {
        return this.valorDescontos;
    }

    public void setValorDescontos(Double valorDescontos) {
        this.valorDescontos = valorDescontos;
    }

    @Column(nullable=false, name="TOTAL_ABATIMENTOS", precision=15, scale=4)
    public Double getTotalAbatimentos() {
        return this.totalAbatimentos;
    }

    public void setTotalAbatimentos(Double totalAbatimentos) {
        this.totalAbatimentos = totalAbatimentos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @OneToOne(targetEntity=CondicoesPagamento.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_GRUPO_APURACAO_LOC_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=50)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @OneToOne(mappedBy="grupoApuracaoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public Rps getRps() {
        return this.rps;
    }

    public void setRps(Rps rps) {
        this.rps = rps;
    }

    @OneToOne(mappedBy="grupoApuracaoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public NotaContratoLocacao getNota() {
        return this.nota;
    }

    public void setNota(NotaContratoLocacao nota) {
        this.nota = nota;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToOne(targetEntity=TomadorPrestadorRps.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TOMADOR", foreignKey=@ForeignKey(name="FK_GRUPO_APURACAO_LOCACAO_TOM"))
    public TomadorPrestadorRps getTomador() {
        return this.tomador;
    }

    public void setTomador(TomadorPrestadorRps tomador) {
        this.tomador = tomador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

