/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.RetornoCnabCobranca;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRUPO_DE_BAIXA")
public class GrupoDeBaixa
implements InterfaceVO {
    private Long identificador;
    private Date dataLiquidacao;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private RenegociacaoTitulos renegociacaoTitulos;
    private RetornoCnabCobranca retornoCnab;
    private List<GrupoDeBaixaFormas> grupoDeBaixaFormas = new ArrayList<GrupoDeBaixaFormas>();
    private Short pagRec = 0;
    private String observacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_GRUPO_DE_BAIXA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_DE_BAIXA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_LIQUIDACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiquidacao() {
        return this.dataLiquidacao;
    }

    public void setDataLiquidacao(Date dataLiquidacao) {
        this.dataLiquidacao = dataLiquidacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Grupo de Baixa Id: {0} Data: {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataLiquidacao())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="grupoDeBaixa", fetch=FetchType.LAZY, targetEntity=RenegociacaoTitulos.class)
    public RenegociacaoTitulos getRenegociacaoTitulos() {
        return this.renegociacaoTitulos;
    }

    public void setRenegociacaoTitulos(RenegociacaoTitulos renegociacaoTitulos) {
        this.renegociacaoTitulos = renegociacaoTitulos;
    }

    @OneToOne(mappedBy="grupoBaixa", fetch=FetchType.LAZY, targetEntity=RetornoCnabCobranca.class)
    public RetornoCnabCobranca getRetornoCnab() {
        return this.retornoCnab;
    }

    public void setRetornoCnab(RetornoCnabCobranca retornoCnab) {
        this.retornoCnab = retornoCnab;
    }

    @OneToMany(mappedBy="grupoDeBaixa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GrupoDeBaixaFormas> getGrupoDeBaixaFormas() {
        return this.grupoDeBaixaFormas;
    }

    public void setGrupoDeBaixaFormas(List<GrupoDeBaixaFormas> grupoDeBaixaFormas) {
        this.grupoDeBaixaFormas = grupoDeBaixaFormas;
    }

    @Column(nullable=false, name="PAGREC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

