/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="GRUPO_PESSOAS")
public class GrupoPessoas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private List<Pessoa> pessoas = new ArrayList<Pessoa>();
    private Timestamp dataAtualizacao;
    private String nomeGrupo;
    private Short habilParaCompra = 0;
    private Double limiteCredito = 0.0;
    private Double limiteCreditoFinanceiro = 0.0;
    private Date dataLiberacaoCredito;
    private Integer diasVigorLimiteCred = 0;
    private String observacao;
    private Short naoAvaliarFinanceiro = 0;
    private Short ativo = 1;

    @Id
    @Column(nullable=false, unique=true, name="ID_GRUPO_PESSOA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_PESSOA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRUPO_PESSOAS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="grupoPessoas", cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<Pessoa> getPessoas() {
        return this.pessoas;
    }

    public void setPessoas(List<Pessoa> pessoas) {
        this.pessoas = pessoas;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NOME_GRUPO", length=60)
    public String getNomeGrupo() {
        return this.nomeGrupo;
    }

    public void setNomeGrupo(String nomeGrupo) {
        this.nomeGrupo = nomeGrupo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNomeGrupo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="HABIL_PARA_COMPRA")
    public Short getHabilParaCompra() {
        return this.habilParaCompra;
    }

    public void setHabilParaCompra(Short habilParaCompra) {
        this.habilParaCompra = habilParaCompra;
    }

    @Column(nullable=false, name="LIMITE_CREDITO", precision=15, scale=2)
    public Double getLimiteCredito() {
        return this.limiteCredito;
    }

    public void setLimiteCredito(Double limiteCredito) {
        this.limiteCredito = limiteCredito;
    }

    @Column(name="DATA_LIBERACAO_CREDITO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiberacaoCredito() {
        return this.dataLiberacaoCredito;
    }

    public void setDataLiberacaoCredito(Date dataLiberacaoCredito) {
        this.dataLiberacaoCredito = dataLiberacaoCredito;
    }

    @Column(name="DIAS_VIGOR_LIMITE_CRED")
    public Integer getDiasVigorLimiteCred() {
        return this.diasVigorLimiteCred;
    }

    public void setDiasVigorLimiteCred(Integer diasVigorLimiteCred) {
        this.diasVigorLimiteCred = diasVigorLimiteCred;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="NAO_AVALIAR_FINANCEIRO")
    public Short getNaoAvaliarFinanceiro() {
        return this.naoAvaliarFinanceiro;
    }

    public void setNaoAvaliarFinanceiro(Short naoAvaliarFinanceiro) {
        this.naoAvaliarFinanceiro = naoAvaliarFinanceiro;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="LIMITE_CREDITO_FINANCEIRO", precision=15, scale=2)
    public Double getLimiteCreditoFinanceiro() {
        return this.limiteCreditoFinanceiro;
    }

    public void setLimiteCreditoFinanceiro(Double limiteCreditoFinanceiro) {
        this.limiteCreditoFinanceiro = limiteCreditoFinanceiro;
    }
}

