/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroHorario;
import com.touchcomp.basementor.model.vo.EsocTipoJornadaTrabalho;
import com.touchcomp.basementor.model.vo.HoraExtraHorTrab;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="HORARIO_TRABALHO", uniqueConstraints={@UniqueConstraint(name="UNQ1_HORARIO_TRABALHO", columnNames={"DESCRICAO", "ID_EMPRESA"})})
public class HorarioTrabalho
implements InterfaceVO {
    private String descricao;
    private Empresa empresa;
    private Date dataCadastro;
    private Long identificador;
    private Timestamp dataAtualizacao;
    private String observacao;
    private Date dataInicial;
    private Date dataFinal;
    private List<DiaHorarioTrabalho> diaHorarioTrabalho = new ArrayList<DiaHorarioTrabalho>();
    private List<HoraExtraHorTrab> horasExtras = new ArrayList<HoraExtraHorTrab>();
    private TurnoDeTrabalho turnoDeTrabalho;
    private String descricaoHorario;
    private String diaFolga;
    private String expressaoRegularHor;
    private Short tipoExpressaoReg = 0;
    private EsocTipoJornadaTrabalho tipoJornada;
    private Short utilizacaoExclusivaDp = 0;
    private Short permiteFlexibilidade = 1;
    private Short intervaloHorarioFixo = 1;
    private Short escalaRevezamento = 0;
    private Double horasTrabalhadasRevezamento = 0.0;
    private Double horasFolgasRevezamento = 0.0;
    private Date entradaRevezamento;
    private Date inicioIntervaloRevezamento;
    private Date finalIntervaloRevezamento;
    private Date saidaRevezamento;
    private Short escalaDiferenciada = 0;
    private String descricaoEscalaDiferenciada;
    private Short informarHorarioCadColaborador = 0;
    private EsocCadastroHorario esocCadastroHorario;
    private Short horarioSemIntervalo = 0;
    private Short descartarApuracaoPonto = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_HORARIO_TRABALHO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_HORARIO_TRABALHO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_HORARIO_TRABALHO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="horarioTrabalho", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<DiaHorarioTrabalho> getDiaHorarioTrabalho() {
        return this.diaHorarioTrabalho;
    }

    public void setDiaHorarioTrabalho(List<DiaHorarioTrabalho> diaHorarioTrabalho) {
        this.diaHorarioTrabalho = diaHorarioTrabalho;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToMany(mappedBy="horarioTrabalho", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<HoraExtraHorTrab> getHorasExtras() {
        return this.horasExtras;
    }

    public void setHorasExtras(List<HoraExtraHorTrab> horasExtras) {
        this.horasExtras = horasExtras;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TURNO_DE_TRABALHO", foreignKey=@ForeignKey(name="FK_HORARIO_TRABALHO_TUR_TRABALH"))
    public TurnoDeTrabalho getTurnoDeTrabalho() {
        return this.turnoDeTrabalho;
    }

    public void setTurnoDeTrabalho(TurnoDeTrabalho turnoDeTrabalho) {
        this.turnoDeTrabalho = turnoDeTrabalho;
    }

    @Column(name="DESCRICAO_HORARIO", length=500)
    public String getDescricaoHorario() {
        return this.descricaoHorario;
    }

    public void setDescricaoHorario(String descricaoHorario) {
        this.descricaoHorario = descricaoHorario;
    }

    @Column(name="DIA_FOLGA", length=20)
    public String getDiaFolga() {
        return this.diaFolga;
    }

    public void setDiaFolga(String diaFolga) {
        this.diaFolga = diaFolga;
    }

    @Column(name="EXPRESSAO_REGULAR_HOR", length=1000)
    public String getExpressaoRegularHor() {
        return this.expressaoRegularHor;
    }

    public void setExpressaoRegularHor(String expressaoRegularHor) {
        this.expressaoRegularHor = expressaoRegularHor;
    }

    @Column(name="TIPO_EXPRESSAO_REG")
    public Short getTipoExpressaoReg() {
        return this.tipoExpressaoReg;
    }

    public void setTipoExpressaoReg(Short tipoExpressaoReg) {
        this.tipoExpressaoReg = tipoExpressaoReg;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_JORNADA", foreignKey=@ForeignKey(name="FK_HORARIO_TRABALHO_TP_JOR"))
    public EsocTipoJornadaTrabalho getTipoJornada() {
        return this.tipoJornada;
    }

    public void setTipoJornada(EsocTipoJornadaTrabalho tipoJornada) {
        this.tipoJornada = tipoJornada;
    }

    @Column(name="UTILIZACAO_EXCLUSIVA_DP")
    public Short getUtilizacaoExclusivaDp() {
        return this.utilizacaoExclusivaDp;
    }

    public void setUtilizacaoExclusivaDp(Short utilizacaoExclusivaDp) {
        this.utilizacaoExclusivaDp = utilizacaoExclusivaDp;
    }

    @Column(name="PERMITE_FLEXIBILIDADE")
    public Short getPermiteFlexibilidade() {
        return this.permiteFlexibilidade;
    }

    public void setPermiteFlexibilidade(Short permiteFlexibilidade) {
        this.permiteFlexibilidade = permiteFlexibilidade;
    }

    @Column(name="INTERVALO_HORARIO_FIXO")
    public Short getIntervaloHorarioFixo() {
        return this.intervaloHorarioFixo;
    }

    public void setIntervaloHorarioFixo(Short intervaloHorarioFixo) {
        this.intervaloHorarioFixo = intervaloHorarioFixo;
    }

    @Column(name="ESCALA_REVEZAMENTO")
    public Short getEscalaRevezamento() {
        return this.escalaRevezamento;
    }

    public void setEscalaRevezamento(Short escalaRevezamento) {
        this.escalaRevezamento = escalaRevezamento;
    }

    @Column(name="HORAS_TRABALHADAS_REVEZAMENTO", precision=15, scale=4)
    public Double getHorasTrabalhadasRevezamento() {
        return this.horasTrabalhadasRevezamento;
    }

    public void setHorasTrabalhadasRevezamento(Double horasTrabalhadasRevezamento) {
        this.horasTrabalhadasRevezamento = horasTrabalhadasRevezamento;
    }

    @Column(name="HORAS_FOLGAS_REVEZAMENTO", precision=15, scale=4)
    public Double getHorasFolgasRevezamento() {
        return this.horasFolgasRevezamento;
    }

    public void setHorasFolgasRevezamento(Double horasFolgasRevezamento) {
        this.horasFolgasRevezamento = horasFolgasRevezamento;
    }

    @Column(name="ENTRADA_REVEZAMENTO")
    @Temporal(value=TemporalType.TIME)
    public Date getEntradaRevezamento() {
        return this.entradaRevezamento;
    }

    public void setEntradaRevezamento(Date entradaRevezamento) {
        this.entradaRevezamento = entradaRevezamento;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="INICIO_INTERVALO_REVEZAMENTO")
    public Date getInicioIntervaloRevezamento() {
        return this.inicioIntervaloRevezamento;
    }

    public void setInicioIntervaloRevezamento(Date inicioIntervaloRevezamento) {
        this.inicioIntervaloRevezamento = inicioIntervaloRevezamento;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="FINAL_INTERVALO_REVEZAMENTO")
    public Date getFinalIntervaloRevezamento() {
        return this.finalIntervaloRevezamento;
    }

    public void setFinalIntervaloRevezamento(Date finalIntervaloRevezamento) {
        this.finalIntervaloRevezamento = finalIntervaloRevezamento;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="SAIDA_REVEZAMENTO")
    public Date getSaidaRevezamento() {
        return this.saidaRevezamento;
    }

    public void setSaidaRevezamento(Date saidaRevezamento) {
        this.saidaRevezamento = saidaRevezamento;
    }

    @Column(name="ESCALA_DIFERENCIADA")
    public Short getEscalaDiferenciada() {
        return this.escalaDiferenciada;
    }

    public void setEscalaDiferenciada(Short escalaDiferenciada) {
        this.escalaDiferenciada = escalaDiferenciada;
    }

    @Column(name="DESCRICAO_ESCALA_DIFERENCIADA", length=400)
    public String getDescricaoEscalaDiferenciada() {
        return this.descricaoEscalaDiferenciada;
    }

    public void setDescricaoEscalaDiferenciada(String descricaoEscalaDiferenciada) {
        this.descricaoEscalaDiferenciada = descricaoEscalaDiferenciada;
    }

    @Column(name="INFO_HORARIO_CAD_COLABORADOR")
    public Short getInformarHorarioCadColaborador() {
        return this.informarHorarioCadColaborador;
    }

    public void setInformarHorarioCadColaborador(Short informarHorarioCadColaborador) {
        this.informarHorarioCadColaborador = informarHorarioCadColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CAD_HORARIO", foreignKey=@ForeignKey(name="FK_HORARIO_TRABALHO_ESOC_CAD_HO"))
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE, CascadeType.DELETE_ORPHAN})
    public EsocCadastroHorario getEsocCadastroHorario() {
        return this.esocCadastroHorario;
    }

    public void setEsocCadastroHorario(EsocCadastroHorario esocCadastroHorario) {
        this.esocCadastroHorario = esocCadastroHorario;
    }

    @Column(name="horario_sem_intervalo")
    public Short getHorarioSemIntervalo() {
        return this.horarioSemIntervalo;
    }

    public void setHorarioSemIntervalo(Short horarioSemIntervalo) {
        this.horarioSemIntervalo = horarioSemIntervalo;
    }

    @Column(name="descartar_apuracao_ponto")
    public Short getDescartarApuracaoPonto() {
        return this.descartarApuracaoPonto;
    }

    public void setDescartarApuracaoPonto(Short descartarApuracaoPonto) {
        this.descartarApuracaoPonto = descartarApuracaoPonto;
    }
}

