/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoEspecie;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoItem;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoNaturezaRequisicao;
import com.touchcomp.basementor.model.vo.IntegracaoRequisicaoSubespecie;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INTEGRACAO_REQUISICAO")
public class IntegracaoRequisicao
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private Date dataFinal;
    private Short gerarLancContabil = 0;
    private Short gerarLancGerencial = 0;
    private Short gerarLancCentroCusto = 0;
    private List<IntegracaoRequisicaoEspecie> especies;
    private List<IntegracaoRequisicaoSubespecie> subespecies;
    private Short filtrarEmpresa = 0;
    private String observacao;
    private Short excluirItensCustoZero = 0;
    private List<IntegracaoRequisicaoItem> itens = new LinkedList<IntegracaoRequisicaoItem>();
    private List<IntegracaoRequisicaoNaturezaRequisicao> naturezasRequisicao;
    private Empresa empresa;
    private Short atualizarPlanoConta = 0;
    private Short gerarLancAnalitico = 0;

    public IntegracaoRequisicao() {
        this.especies = new ArrayList<IntegracaoRequisicaoEspecie>();
        this.subespecies = new ArrayList<IntegracaoRequisicaoSubespecie>();
        this.naturezasRequisicao = new ArrayList<IntegracaoRequisicaoNaturezaRequisicao>();
    }

    @Id
    @Column(name="ID_INTEGRACAO_REQUISICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INTEGRACAO_REQUISICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="GERAR_LANC_CONTABIL")
    public Short getGerarLancContabil() {
        return this.gerarLancContabil;
    }

    public void setGerarLancContabil(Short gerarLancContabil) {
        this.gerarLancContabil = gerarLancContabil;
    }

    @Column(name="GERAR_LANC_GERENCIAL")
    public Short getGerarLancGerencial() {
        return this.gerarLancGerencial;
    }

    public void setGerarLancGerencial(Short gerarLancGerencial) {
        this.gerarLancGerencial = gerarLancGerencial;
    }

    @Column(name="GERAR_LANC_CENTRO_CUSTO")
    public Short getGerarLancCentroCusto() {
        return this.gerarLancCentroCusto;
    }

    public void setGerarLancCentroCusto(Short gerarLancCentroCusto) {
        this.gerarLancCentroCusto = gerarLancCentroCusto;
    }

    @OneToMany(mappedBy="integracaoRequisicao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegracaoRequisicaoEspecie> getEspecies() {
        return this.especies;
    }

    public void setEspecies(List<IntegracaoRequisicaoEspecie> especies) {
        this.especies = especies;
    }

    @OneToMany(mappedBy="integracaoRequisicao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegracaoRequisicaoSubespecie> getSubespecies() {
        return this.subespecies;
    }

    public void setSubespecies(List<IntegracaoRequisicaoSubespecie> subespecies) {
        this.subespecies = subespecies;
    }

    @Column(name="FILTRAR_EMPRESA")
    public Short getFiltrarEmpresa() {
        return this.filtrarEmpresa;
    }

    public void setFiltrarEmpresa(Short filtrarEmpresa) {
        this.filtrarEmpresa = filtrarEmpresa;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="EXCLUIR_ITENS_CUSTO_ZERO")
    public Short getExcluirItensCustoZero() {
        return this.excluirItensCustoZero;
    }

    public void setExcluirItensCustoZero(Short excluirItensCustoZero) {
        this.excluirItensCustoZero = excluirItensCustoZero;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="integracaoRequisicao", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<IntegracaoRequisicaoItem> getItens() {
        return this.itens;
    }

    public void setItens(List<IntegracaoRequisicaoItem> itens) {
        this.itens = itens;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INTEGRACAO_REQ_EMP_LOGADA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="ATUALIZAR_PLANO_CONTA")
    public Short getAtualizarPlanoConta() {
        return this.atualizarPlanoConta;
    }

    public void setAtualizarPlanoConta(Short atualizarPlanoConta) {
        this.atualizarPlanoConta = atualizarPlanoConta;
    }

    @OneToMany(mappedBy="integracaoRequisicao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<IntegracaoRequisicaoNaturezaRequisicao> getNaturezasRequisicao() {
        return this.naturezasRequisicao;
    }

    public void setNaturezasRequisicao(List<IntegracaoRequisicaoNaturezaRequisicao> naturezasRequisicao) {
        this.naturezasRequisicao = naturezasRequisicao;
    }

    @Column(name="GERAR_LANC_ANALITICO")
    public Short getGerarLancAnalitico() {
        return this.gerarLancAnalitico;
    }

    public void setGerarLancAnalitico(Short gerarLancAnalitico) {
        this.gerarLancAnalitico = gerarLancAnalitico;
    }
}

