/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CadastroRateioValorPlanoSaude;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ItemCadastroDependentePlanoSaude;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_RATEIO_VALOR_PLANO_SAUDE")
public class ItemCadastroRateioValorPlanoSaude
implements InterfaceVO {
    private Long identificador;
    private Colaborador colaborador;
    private Double valorTotalDescontoPlanoSaude = 0.0;
    private Double valorPlanoSaudeTitular = 0.0;
    private CadastroRateioValorPlanoSaude rateioPlanoSaude;
    private List<ItemCadastroDependentePlanoSaude> itensDepentendes = new ArrayList<ItemCadastroDependentePlanoSaude>();

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_RATEIO_SAUDE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_RATEIO_PLANO_SAUDE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RATEIO_PLANO_SAUDE", foreignKey=@ForeignKey(name="FK_ITEM_RATEIO_VALOR_PLANO_SAUD"))
    public CadastroRateioValorPlanoSaude getRateioPlanoSaude() {
        return this.rateioPlanoSaude;
    }

    public void setRateioPlanoSaude(CadastroRateioValorPlanoSaude rateioPlanoSaude) {
        this.rateioPlanoSaude = rateioPlanoSaude;
    }

    @OneToMany(mappedBy="itemCadastroRateio", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemCadastroDependentePlanoSaude> getItensDepentendes() {
        return this.itensDepentendes;
    }

    public void setItensDepentendes(List<ItemCadastroDependentePlanoSaude> itensDepentendes) {
        this.itensDepentendes = itensDepentendes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_ITEM_RATEIO_VALOR_PLANO_COLA"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(nullable=false, name="VALOR_PLANO_SAUDE_TITULAR", precision=15, scale=4)
    public Double getValorPlanoSaudeTitular() {
        return this.valorPlanoSaudeTitular;
    }

    public void setValorPlanoSaudeTitular(Double valorPlanoSaudeTitular) {
        this.valorPlanoSaudeTitular = valorPlanoSaudeTitular;
    }

    @Column(nullable=false, name="VALOR_TOTAL_DESC_PLANO_SAUDE", precision=15, scale=4)
    public Double getValorTotalDescontoPlanoSaude() {
        return this.valorTotalDescontoPlanoSaude;
    }

    public void setValorTotalDescontoPlanoSaude(Double valorTotalDescontoPlanoSaude) {
        this.valorTotalDescontoPlanoSaude = valorTotalDescontoPlanoSaude;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

